/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.helper.NumberStyle;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.WordUtils;

public enum StringHelpers implements Helper<Object>
{
    capitalizeFirst{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            return StringUtils.capitalize((String)value.toString());
        }
    }
    ,
    center{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            Integer size = (Integer)options.hash("size");
            Validate.notNull((Object)size, (String)"found 'null', expected 'size'", (Object[])new Object[0]);
            String pad = (String)options.hash("pad", " ");
            return StringUtils.center((String)value.toString(), (int)size, (String)pad);
        }
    }
    ,
    cut{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            String strip = options.param(0, " ");
            return value.toString().replace(strip, "");
        }
    }
    ,
    defaultIfEmpty{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            if (Handlebars.Utils.isEmpty(value)) {
                return options.param(0, "");
            }
            return String.valueOf(value);
        }

        @Override
        protected CharSequence safeApply(Object context, Options options) {
            return null;
        }
    }
    ,
    join{

        @Override
        public CharSequence apply(Object context, Options options) {
            if (options.isFalsy(context)) {
                return "";
            }
            return this.safeApply(context, options);
        }

        @Override
        protected CharSequence safeApply(Object context, Options options) {
            int separatorIdx = options.params.length - 1;
            Object separator = options.param(separatorIdx, null);
            Validate.notNull(separator, (String)"found 'null', expected 'separator' at param[%s]", (Object[])new Object[]{separatorIdx});
            Validate.isTrue((boolean)(separator instanceof String), (String)"found '%s', expected 'separator' at param[%s]", (Object[])new Object[]{separator, separatorIdx});
            String prefix = (String)options.hash("prefix", "");
            String suffix = (String)options.hash("suffix", "");
            if (context instanceof Iterable) {
                return prefix + StringUtils.join((Iterable)((Iterable)context), (String)separator) + suffix;
            }
            if (context instanceof Iterator) {
                return prefix + StringUtils.join((Iterator)((Iterator)context), (String)separator) + suffix;
            }
            if (context.getClass().isArray()) {
                return prefix + StringUtils.join((Object[])((Object[])context), (String)separator) + suffix;
            }
            Object[] values = new Object[options.params.length];
            System.arraycopy(options.params, 0, values, 1, separatorIdx);
            values[0] = context;
            return prefix + StringUtils.join((Object[])values, (String)separator) + suffix;
        }
    }
    ,
    ljust{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            Integer size = (Integer)options.hash("size");
            Validate.notNull((Object)size, (String)"found 'null', expected 'size'", (Object[])new Object[0]);
            String pad = (String)options.hash("pad", " ");
            return StringUtils.rightPad((String)value.toString(), (int)size, (String)pad);
        }
    }
    ,
    rjust{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            Integer size = (Integer)options.hash("size");
            Validate.notNull((Object)size, (String)"found 'null', expected 'size'", (Object[])new Object[0]);
            String pad = (String)options.hash("pad", " ");
            return StringUtils.leftPad((String)value.toString(), (int)size, (String)pad);
        }
    }
    ,
    substring{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            Validate.validIndex((Object[])options.params, (int)0, (String)"Required start offset: ", (Object[])new Object[0]);
            String str = value.toString();
            Integer start = (Integer)options.param(0);
            Integer end = options.param(1, str.length());
            return str.subSequence(start, end);
        }
    }
    ,
    lower{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            return value.toString().toLowerCase();
        }
    }
    ,
    upper{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            return value.toString().toUpperCase();
        }
    }
    ,
    slugify{

        @Override
        protected CharSequence safeApply(Object context, Options options) {
            String value = StringUtils.strip((String)context.toString());
            StringBuilder buffer = new StringBuilder(value.length());
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (Character.isLetter(ch)) {
                    buffer.append(Character.toLowerCase(ch));
                }
                if (!Character.isWhitespace(ch)) continue;
                buffer.append('-');
            }
            return buffer.toString();
        }
    }
    ,
    stringFormat{

        @Override
        protected CharSequence safeApply(Object format, Options options) {
            return String.format(format.toString(), options.params);
        }
    }
    ,
    stripTags{
        private final Pattern pattern = Pattern.compile("\\<[^>]*>", 32);

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            Matcher matcher = this.pattern.matcher(value.toString());
            return matcher.replaceAll("");
        }
    }
    ,
    capitalize{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            Boolean fully = (Boolean)options.hash("fully", false);
            return fully != false ? WordUtils.capitalizeFully((String)value.toString()) : WordUtils.capitalize((String)value.toString());
        }
    }
    ,
    abbreviate{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            Integer width = options.param(0, null);
            Validate.notNull((Object)width, (String)"found 'null', expected 'width'", (Object[])new Object[0]);
            return StringUtils.abbreviate((String)value.toString(), (int)width);
        }
    }
    ,
    wordWrap{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            Integer length = options.param(0, null);
            Validate.notNull((Object)length, (String)"found 'null', expected 'length'", (Object[])new Object[0]);
            return WordUtils.wrap((String)value.toString(), (int)length);
        }
    }
    ,
    replace{

        @Override
        public CharSequence safeApply(Object value, Options options) {
            String target = options.param(0, null);
            String replacement = options.param(1, null);
            return value.toString().replace(target, replacement);
        }
    }
    ,
    yesno{

        @Override
        public CharSequence apply(Object value, Options options) throws IOException {
            if (value == null) {
                return (CharSequence)options.hash("maybe", "maybe");
            }
            Validate.isTrue((boolean)(value instanceof Boolean), (String)"found '%s', expected 'boolean'", (Object[])new Object[]{value});
            if (Boolean.TRUE.equals(value)) {
                return (CharSequence)options.hash("yes", "yes");
            }
            return (CharSequence)options.hash("no", "no");
        }

        @Override
        protected CharSequence safeApply(Object context, Options options) {
            return null;
        }
    }
    ,
    dateFormat{
        private Map<String, Integer> styles = new HashMap<String, Integer>(){
            {
                this.put("full", 0);
                this.put("long", 1);
                this.put("medium", 2);
                this.put("short", 3);
            }
        };

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            Validate.isTrue((boolean)(value instanceof Date), (String)"found '%s', expected 'date'", (Object[])new Object[]{value});
            Date date = (Date)value;
            Object pattern = options.param(0, options.hash("format", "medium"));
            String localeStr = options.param(1, Locale.getDefault().toString());
            Locale locale = LocaleUtils.toLocale((String)localeStr);
            Integer style = this.styles.get(pattern);
            DateFormat dateFormat = style == null ? new SimpleDateFormat(pattern.toString(), locale) : DateFormat.getDateInstance(style, locale);
            Object tz = options.hash("tz");
            if (tz != null) {
                TimeZone timeZone = tz instanceof TimeZone ? (TimeZone)tz : TimeZone.getTimeZone(tz.toString());
                dateFormat.setTimeZone(timeZone);
            }
            return dateFormat.format(date);
        }
    }
    ,
    numberFormat{

        @Override
        public CharSequence apply(Object context, Options options) throws IOException {
            if (context instanceof Number) {
                return this.safeApply(context, options);
            }
            Object param = options.param(0, null);
            return param == null ? null : param.toString();
        }

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            String roundingMode;
            Boolean parseIntegerOnly;
            Integer minimumIntegerDigits;
            Integer minimumFractionDigits;
            Integer maximumIntegerDigits;
            Integer maximumFractionDigits;
            Validate.isTrue((boolean)(value instanceof Number), (String)"found '%s', expected 'number'", (Object[])new Object[]{value});
            Number number = (Number)value;
            NumberFormat numberFormat = this.build(options);
            Boolean groupingUsed = (Boolean)options.hash("groupingUsed");
            if (groupingUsed != null) {
                numberFormat.setGroupingUsed(groupingUsed);
            }
            if ((maximumFractionDigits = (Integer)options.hash("maximumFractionDigits")) != null) {
                numberFormat.setMaximumFractionDigits(maximumFractionDigits);
            }
            if ((maximumIntegerDigits = (Integer)options.hash("maximumIntegerDigits")) != null) {
                numberFormat.setMaximumIntegerDigits(maximumIntegerDigits);
            }
            if ((minimumFractionDigits = (Integer)options.hash("minimumFractionDigits")) != null) {
                numberFormat.setMinimumFractionDigits(minimumFractionDigits);
            }
            if ((minimumIntegerDigits = (Integer)options.hash("minimumIntegerDigits")) != null) {
                numberFormat.setMinimumIntegerDigits(minimumIntegerDigits);
            }
            if ((parseIntegerOnly = (Boolean)options.hash("parseIntegerOnly")) != null) {
                numberFormat.setParseIntegerOnly(parseIntegerOnly);
            }
            if ((roundingMode = (String)options.hash("roundingMode")) != null) {
                numberFormat.setRoundingMode(RoundingMode.valueOf(roundingMode.toUpperCase().trim()));
            }
            return numberFormat.format(number);
        }

        private NumberFormat build(Options options) {
            if (options.params.length == 0) {
                return NumberStyle.DEFAULT.numberFormat(Locale.getDefault());
            }
            Validate.isTrue((boolean)(options.params[0] instanceof String), (String)"found '%s', expected 'string'", (Object[])new Object[]{options.params[0]});
            String format = (String)options.param(0);
            String localeStr = options.param(1, Locale.getDefault().toString());
            Locale locale = LocaleUtils.toLocale((String)localeStr);
            try {
                NumberStyle style = NumberStyle.valueOf(format.toUpperCase().trim());
                return style.numberFormat(locale);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return NumberStyle.DEFAULT.numberFormat(locale);
            }
            catch (IllegalArgumentException ex) {
                return new DecimalFormat(format, new DecimalFormatSymbols(locale));
            }
        }
    }
    ,
    now{

        @Override
        protected CharSequence safeApply(Object value, Options options) {
            return dateFormat.safeApply(new Date(), options);
        }
    };


    @Override
    public CharSequence apply(Object context, Options options) throws IOException {
        if (options.isFalsy(context)) {
            Object param = options.param(0, null);
            return param == null ? null : param.toString();
        }
        return this.safeApply(context, options);
    }

    protected abstract CharSequence safeApply(Object var1, Options var2);

    public void registerHelper(Handlebars handlebars) {
        Validate.notNull((Object)handlebars, (String)"The handlebars is required.", (Object[])new Object[0]);
        handlebars.registerHelper(this.name(), (Helper)this);
    }

    public static void register(Handlebars handlebars) {
        StringHelpers[] helpers;
        Validate.notNull((Object)handlebars, (String)"A handlebars object is required.", (Object[])new Object[0]);
        for (StringHelpers helper : helpers = StringHelpers.values()) {
            helper.registerHelper(handlebars);
        }
    }
}

