/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet.utility.exposed.data;

import com.github.simplenet.utility.exposed.data.ShortReader;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface StringReader
extends ShortReader {
    default public void readString(Consumer<String> consumer) {
        this.readString(consumer, StandardCharsets.UTF_8, ByteOrder.BIG_ENDIAN);
    }

    default public void readString(Consumer<String> consumer, Charset charset) {
        this.readString(consumer, charset, ByteOrder.BIG_ENDIAN);
    }

    default public void readString(Consumer<String> consumer, Charset charset, ByteOrder order) {
        this.readShort(length -> this.processBytes(length, consumer, charset, order));
    }

    default public void readStringUntil(Predicate<String> predicate) {
        this.readStringUntil(predicate, StandardCharsets.UTF_8, ByteOrder.BIG_ENDIAN);
    }

    default public void readStringUntil(Predicate<String> predicate, Charset charset) {
        this.readStringUntil(predicate, charset, ByteOrder.BIG_ENDIAN);
    }

    default public void readStringUntil(Predicate<String> predicate, Charset charset, ByteOrder order) {
        this.readShortUntil(length -> {
            boolean[] toReturn = new boolean[1];
            this.processBytes(length, string -> {
                toReturn[0] = predicate.test((String)string);
            }, charset, order);
            return toReturn[0];
        });
    }

    default public void readStringAlways(Consumer<String> consumer) {
        this.readStringAlways(consumer, StandardCharsets.UTF_8, ByteOrder.BIG_ENDIAN);
    }

    default public void readStringAlways(Consumer<String> consumer, Charset charset) {
        this.readStringAlways(consumer, charset, ByteOrder.BIG_ENDIAN);
    }

    default public void readStringAlways(Consumer<String> consumer, Charset charset, ByteOrder order) {
        this.readShortAlways(length -> this.processBytes(length, consumer, charset, order));
    }

    private void processBytes(short n, Consumer<String> consumer, Charset charset, ByteOrder order) {
        short length = order == ByteOrder.LITTLE_ENDIAN ? Short.reverseBytes(n) : n;
        this.read(1 * (length & 0xFFFF), buffer -> {
            byte[] b = new byte[length];
            buffer.get(b);
            consumer.accept(new String(b, charset));
        }, order);
    }
}

