/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet.utility.exposed.data;

import com.github.simplenet.utility.exposed.consumer.ShortConsumer;
import com.github.simplenet.utility.exposed.data.DataReader;
import com.github.simplenet.utility.exposed.predicate.ShortPredicate;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Consumer;

public interface ShortReader
extends DataReader {
    default public void readShort(ShortConsumer consumer) {
        this.readShort(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readShort(ShortConsumer consumer, ByteOrder order) {
        this.read(2, buffer -> consumer.accept(buffer.getShort()), order);
    }

    default public void readShortUntil(ShortPredicate predicate) {
        this.readShortUntil(predicate, ByteOrder.BIG_ENDIAN);
    }

    default public void readShortUntil(ShortPredicate predicate, ByteOrder order) {
        this.readUntil(2, buffer -> predicate.test(buffer.getShort()), order);
    }

    default public void readShortAlways(ShortConsumer consumer) {
        this.readShortAlways(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readShortAlways(ShortConsumer consumer, ByteOrder order) {
        this.readAlways(2, buffer -> consumer.accept(buffer.getShort()), order);
    }

    default public void readShorts(int n, Consumer<short[]> consumer) {
        this.readShorts(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readShorts(int n, Consumer<short[]> consumer, ByteOrder order) {
        this.read(2 * n, buffer -> this.processShorts((ByteBuffer)buffer, n, consumer), order);
    }

    default public void readShortsAlways(int n, Consumer<short[]> consumer) {
        this.readShortsAlways(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readShortsAlways(int n, Consumer<short[]> consumer, ByteOrder order) {
        this.readAlways(2 * n, buffer -> this.processShorts((ByteBuffer)buffer, n, consumer), order);
    }

    private void processShorts(ByteBuffer buffer, int n, Consumer<short[]> consumer) {
        short[] s = new short[n];
        buffer.asShortBuffer().get(s);
        consumer.accept(s);
    }
}

