/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet.utility.exposed.data;

import com.github.simplenet.utility.exposed.data.DataReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;

public interface LongReader
extends DataReader {
    default public void readLong(LongConsumer consumer) {
        this.readLong(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readLong(LongConsumer consumer, ByteOrder order) {
        this.read(8, buffer -> consumer.accept(buffer.getLong()), order);
    }

    default public void readLongUntil(LongPredicate predicate) {
        this.readLongUntil(predicate, ByteOrder.BIG_ENDIAN);
    }

    default public void readLongUntil(LongPredicate predicate, ByteOrder order) {
        this.readUntil(8, buffer -> predicate.test(buffer.getLong()), order);
    }

    default public void readLongAlways(LongConsumer consumer) {
        this.readLongAlways(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readLongAlways(LongConsumer consumer, ByteOrder order) {
        this.readAlways(8, buffer -> consumer.accept(buffer.getLong()), order);
    }

    default public void readLongs(int n, Consumer<long[]> consumer) {
        this.readLongs(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readLongs(int n, Consumer<long[]> consumer, ByteOrder order) {
        this.read(8 * n, buffer -> this.processLongs((ByteBuffer)buffer, n, consumer), order);
    }

    default public void readLongsAlways(int n, Consumer<long[]> consumer) {
        this.readLongsAlways(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readLongsAlways(int n, Consumer<long[]> consumer, ByteOrder order) {
        this.readAlways(8 * n, buffer -> this.processLongs((ByteBuffer)buffer, n, consumer), order);
    }

    private void processLongs(ByteBuffer buffer, int n, Consumer<long[]> consumer) {
        long[] l = new long[n];
        buffer.asLongBuffer().get(l);
        consumer.accept(l);
    }
}

