/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet.utility.exposed.data;

import com.github.simplenet.utility.exposed.data.DataReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;

public interface IntReader
extends DataReader {
    default public void readInt(IntConsumer consumer) {
        this.readInt(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readInt(IntConsumer consumer, ByteOrder order) {
        this.read(4, buffer -> consumer.accept(buffer.getInt()), order);
    }

    default public void readIntUntil(IntPredicate predicate) {
        this.readIntUntil(predicate, ByteOrder.BIG_ENDIAN);
    }

    default public void readIntUntil(IntPredicate predicate, ByteOrder order) {
        this.readUntil(4, buffer -> predicate.test(buffer.getInt()), order);
    }

    default public void readIntAlways(IntConsumer consumer) {
        this.readIntAlways(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readIntAlways(IntConsumer consumer, ByteOrder order) {
        this.readAlways(4, buffer -> consumer.accept(buffer.getInt()), order);
    }

    default public void readInts(int n, Consumer<int[]> consumer) {
        this.readInts(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readInts(int n, Consumer<int[]> consumer, ByteOrder order) {
        this.read(4 * n, buffer -> this.processInts((ByteBuffer)buffer, n, consumer), order);
    }

    default public void readIntsAlways(int n, Consumer<int[]> consumer) {
        this.readIntsAlways(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readIntsAlways(int n, Consumer<int[]> consumer, ByteOrder order) {
        this.readAlways(4 * n, buffer -> this.processInts((ByteBuffer)buffer, n, consumer), order);
    }

    private void processInts(ByteBuffer buffer, int n, Consumer<int[]> consumer) {
        int[] i = new int[n];
        buffer.asIntBuffer().get(i);
        consumer.accept(i);
    }
}

