/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet.utility.exposed.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Consumer;
import java.util.function.Predicate;

@FunctionalInterface
public interface DataReader {
    default public void read(int n, Consumer<ByteBuffer> consumer) {
        this.read(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void read(int n, Consumer<ByteBuffer> consumer, ByteOrder order) {
        this.readUntil(n, buffer -> {
            consumer.accept((ByteBuffer)buffer);
            return false;
        }, order);
    }

    public void readUntil(int var1, Predicate<ByteBuffer> var2, ByteOrder var3);

    default public void readAlways(int n, Consumer<ByteBuffer> consumer, ByteOrder order) {
        this.readUntil(n, buffer -> {
            consumer.accept((ByteBuffer)buffer);
            return true;
        }, order);
    }
}

