/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet.utility.exposed.data;

import com.github.simplenet.utility.exposed.consumer.CharConsumer;
import com.github.simplenet.utility.exposed.data.DataReader;
import com.github.simplenet.utility.exposed.predicate.CharPredicate;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Consumer;

public interface CharReader
extends DataReader {
    default public void readChar(CharConsumer consumer) {
        this.readChar(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readChar(CharConsumer consumer, ByteOrder order) {
        this.read(2, buffer -> consumer.accept(buffer.getChar()), order);
    }

    default public void readCharUntil(CharPredicate predicate) {
        this.readCharUntil(predicate, ByteOrder.BIG_ENDIAN);
    }

    default public void readCharUntil(CharPredicate predicate, ByteOrder order) {
        this.readUntil(2, buffer -> predicate.test(buffer.getChar()), order);
    }

    default public void readCharAlways(CharConsumer consumer) {
        this.readCharAlways(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readCharAlways(CharConsumer consumer, ByteOrder order) {
        this.readAlways(2, buffer -> consumer.accept(buffer.getChar()), order);
    }

    default public void readChars(int n, Consumer<char[]> consumer) {
        this.readChars(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readChars(int n, Consumer<char[]> consumer, ByteOrder order) {
        this.read(2 * n, buffer -> this.processChars((ByteBuffer)buffer, n, consumer), order);
    }

    default public void readCharsAlways(int n, Consumer<char[]> consumer) {
        this.readCharsAlways(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readCharsAlways(int n, Consumer<char[]> consumer, ByteOrder order) {
        this.readAlways(2 * n, buffer -> this.processChars((ByteBuffer)buffer, n, consumer), order);
    }

    private void processChars(ByteBuffer buffer, int n, Consumer<char[]> consumer) {
        char[] c = new char[n];
        buffer.asCharBuffer().get(c);
        consumer.accept(c);
    }
}

