/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet.utility.exposed.data;

import com.github.simplenet.utility.exposed.consumer.ByteConsumer;
import com.github.simplenet.utility.exposed.data.DataReader;
import com.github.simplenet.utility.exposed.predicate.BytePredicate;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Consumer;

public interface ByteReader
extends DataReader {
    default public void readByte(ByteConsumer consumer) {
        this.read(1, buffer -> consumer.accept(buffer.get()), ByteOrder.BIG_ENDIAN);
    }

    default public void readByteUntil(BytePredicate predicate) {
        this.readUntil(1, buffer -> predicate.test(buffer.get()), ByteOrder.BIG_ENDIAN);
    }

    default public void readByteAlways(ByteConsumer consumer) {
        this.readAlways(1, buffer -> consumer.accept(buffer.get()), ByteOrder.BIG_ENDIAN);
    }

    default public void readBytes(int n, Consumer<byte[]> consumer) {
        this.read(1 * n, buffer -> this.processBytes((ByteBuffer)buffer, n, consumer), ByteOrder.BIG_ENDIAN);
    }

    default public void readBytesAlways(int n, Consumer<byte[]> consumer) {
        this.readAlways(1 * n, buffer -> this.processBytes((ByteBuffer)buffer, n, consumer), ByteOrder.BIG_ENDIAN);
    }

    private void processBytes(ByteBuffer buffer, int n, Consumer<byte[]> consumer) {
        byte[] b = new byte[n];
        buffer.get(b);
        consumer.accept(b);
    }
}

