/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet.utility.exposed.data;

import com.github.simplenet.utility.exposed.consumer.BooleanConsumer;
import com.github.simplenet.utility.exposed.data.DataReader;
import com.github.simplenet.utility.exposed.predicate.BooleanPredicate;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Consumer;

public interface BooleanReader
extends DataReader {
    default public void readBoolean(BooleanConsumer consumer) {
        this.read(1, buffer -> consumer.accept(buffer.get() == 1), ByteOrder.BIG_ENDIAN);
    }

    default public void readBooleanUntil(BooleanPredicate predicate) {
        this.readUntil(1, buffer -> predicate.test(buffer.get() == 1), ByteOrder.BIG_ENDIAN);
    }

    default public void readBooleanAlways(BooleanConsumer consumer) {
        this.readAlways(1, buffer -> consumer.accept(buffer.get() == 1), ByteOrder.BIG_ENDIAN);
    }

    default public void readBooleans(int n, Consumer<boolean[]> consumer) {
        this.read(1 * n, buffer -> this.processBooleans((ByteBuffer)buffer, n, consumer), ByteOrder.BIG_ENDIAN);
    }

    default public void readBooleansAlways(int n, Consumer<boolean[]> consumer) {
        this.readAlways(1 * n, buffer -> this.processBooleans((ByteBuffer)buffer, n, consumer), ByteOrder.BIG_ENDIAN);
    }

    private void processBooleans(ByteBuffer buffer, int n, Consumer<boolean[]> consumer) {
        boolean[] b = new boolean[n];
        for (int i = 0; i < n; ++i) {
            b[i] = buffer.get() == 1;
        }
        consumer.accept(b);
    }
}

