/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet.utility.exposed.cryptography;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

@FunctionalInterface
public interface CryptographicFunction {
    public static final CryptographicFunction DO_FINAL = (cipher, data) -> {
        ByteBuffer output = data.duplicate().limit(cipher.getOutputSize(data.limit()));
        cipher.doFinal(data, output);
        return output;
    };
    public static final CryptographicFunction UPDATE = (cipher, data) -> {
        ByteBuffer output = data.duplicate().limit(cipher.getOutputSize(data.limit()));
        cipher.update(data, output);
        return output;
    };

    public ByteBuffer apply(Cipher var1, ByteBuffer var2) throws GeneralSecurityException;
}

