/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet.packet;

import com.github.simplenet.Client;
import com.github.simplenet.utility.Utility;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Queue;
import java.util.function.Consumer;
import javax.crypto.Cipher;

public final class Packet {
    private boolean prepend;
    private int size;
    private final Deque<Consumer<ByteBuffer>> stack;
    private final Deque<Consumer<ByteBuffer>> queue = new ArrayDeque<Consumer<ByteBuffer>>(4);

    private Packet() {
        this.stack = new ArrayDeque<Consumer<ByteBuffer>>(1);
    }

    public static Packet builder() {
        return new Packet();
    }

    private Packet enqueue(Consumer<ByteBuffer> consumer) {
        if (this.prepend) {
            this.stack.push(consumer);
        } else {
            this.queue.offerLast(consumer);
        }
        return this;
    }

    public Packet putBoolean(boolean b) {
        ++this.size;
        return this.enqueue(buffer -> buffer.put(b ? (byte)1 : (byte)0));
    }

    public Packet putByte(int b) {
        ++this.size;
        return this.enqueue(buffer -> buffer.put((byte)b));
    }

    public Packet putBytes(byte ... src) {
        this.size += 1 * src.length;
        return this.enqueue(buffer -> buffer.put(src));
    }

    public Packet putChar(char c) {
        return this.putChar(c, ByteOrder.BIG_ENDIAN);
    }

    public Packet putChar(char c, ByteOrder order) {
        this.size += 2;
        return this.enqueue(buffer -> buffer.putChar(order == ByteOrder.LITTLE_ENDIAN ? Character.reverseBytes(c) : c));
    }

    public Packet putDouble(double d) {
        return this.putDouble(d, ByteOrder.BIG_ENDIAN);
    }

    public Packet putDouble(double d, ByteOrder order) {
        return this.putLong(Double.doubleToRawLongBits(d), order);
    }

    public Packet putFloat(float f) {
        return this.putFloat(f, ByteOrder.BIG_ENDIAN);
    }

    public Packet putFloat(float f, ByteOrder order) {
        return this.putInt(Float.floatToRawIntBits(f), order);
    }

    public Packet putInt(int i) {
        return this.putInt(i, ByteOrder.BIG_ENDIAN);
    }

    public Packet putInt(int i, ByteOrder order) {
        this.size += 4;
        return this.enqueue(buffer -> buffer.putInt(order == ByteOrder.LITTLE_ENDIAN ? Integer.reverseBytes(i) : i));
    }

    public Packet putLong(long l) {
        return this.putLong(l, ByteOrder.BIG_ENDIAN);
    }

    public Packet putLong(long l, ByteOrder order) {
        this.size += 8;
        return this.enqueue(buffer -> buffer.putLong(order == ByteOrder.LITTLE_ENDIAN ? Long.reverseBytes(l) : l));
    }

    public Packet putShort(int s) {
        return this.putShort(s, ByteOrder.BIG_ENDIAN);
    }

    public Packet putShort(int s, ByteOrder order) {
        this.size += 2;
        short value = (short)s;
        return this.enqueue(buffer -> buffer.putShort(order == ByteOrder.LITTLE_ENDIAN ? Short.reverseBytes(value) : value));
    }

    public Packet putString(String s) {
        return this.putString(s, StandardCharsets.UTF_8, ByteOrder.BIG_ENDIAN);
    }

    public Packet putString(String s, Charset charset) {
        return this.putString(s, charset, ByteOrder.BIG_ENDIAN);
    }

    public Packet putString(String s, Charset charset, ByteOrder order) {
        byte[] bytes = s.getBytes(charset);
        this.putShort(bytes.length, order);
        this.putBytes(bytes);
        return this;
    }

    public Packet prepend(Consumer<Packet> consumer) {
        this.prepend = true;
        consumer.accept(this);
        while (!this.stack.isEmpty()) {
            this.queue.offerFirst(this.stack.pop());
        }
        this.prepend = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void queue(Client client) {
        Queue<Packet> clientQueue;
        Queue<Packet> queue = clientQueue = client.getOutgoingPackets();
        synchronized (clientQueue) {
            clientQueue.offer(this);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public final void queue(Client ... clients) {
        for (Client client : clients) {
            this.queue(client);
        }
    }

    public final void queue(Collection<? extends Client> clients) {
        clients.forEach(this::queue);
    }

    public final void queueAndFlush(Client client) {
        this.queue(client);
        client.flush();
    }

    public final void queueAndFlush(Client ... clients) {
        for (Client client : clients) {
            this.queueAndFlush(client);
        }
    }

    public final void queueAndFlush(Collection<? extends Client> clients) {
        clients.forEach(this::queueAndFlush);
    }

    public int getSize() {
        return this.getSize(null);
    }

    public int getSize(Client client) {
        Cipher encryptionCipher;
        if (client == null || (encryptionCipher = client.getEncryptionCipher()) == null) {
            return this.size;
        }
        if (!client.isEncryptionNoPadding()) {
            int blockSize = encryptionCipher.getBlockSize();
            return Utility.roundUpToNextMultiple(this.size, blockSize == 0 ? encryptionCipher.getOutputSize(this.size) : blockSize);
        }
        return this.size;
    }

    public Deque<Consumer<ByteBuffer>> getQueue() {
        return this.queue;
    }
}

