/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet;

import com.github.simplenet.AbstractReceiver;
import com.github.simplenet.Channeled;
import com.github.simplenet.Client;
import com.github.simplenet.packet.Packet;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
extends AbstractReceiver<Consumer<Client>>
implements Channeled<AsynchronousServerSocketChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private final Set<Client> connectedClients = ConcurrentHashMap.newKeySet();
    private AsynchronousChannelGroup group;
    private AsynchronousServerSocketChannel channel;

    public void bind(String address, int port) {
        this.bind(address, port, Math.max(2, Runtime.getRuntime().availableProcessors() - 2));
    }

    public void bind(String address, int port, int numThreads) {
        Objects.requireNonNull(address);
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The port must be between 0 and 65535!");
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(false);
            thread.setName(thread.getName().replace("Thread", "SimpleNet"));
            return thread;
        }, (runnable, threadPoolExecutor) -> {});
        executor.prestartCoreThread();
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(executor);
            this.channel = AsynchronousServerSocketChannel.open(this.group);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)8192);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open the AsynchronousServerSocketChannel!", e);
        }
        try {
            this.channel.bind(new InetSocketAddress(address, port));
            this.channel.accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(){

                @Override
                public void completed(AsynchronousSocketChannel channel, Void attachment) {
                    Client client = new Client(channel);
                    Server.this.connectedClients.add(client);
                    client.postDisconnect(() -> Server.this.connectedClients.remove(client));
                    Server.this.connectListeners.forEach(consumer -> consumer.accept(client));
                    Server.this.channel.accept(null, this);
                }

                @Override
                public void failed(Throwable t, Void attachment) {
                    LOGGER.debug("An exception occurred when accepting a Client!", t);
                }
            });
            LOGGER.info("Successfully bound to {}:{}!", (Object)address, (Object)port);
        }
        catch (AlreadyBoundException e) {
            throw new IllegalStateException("This server is already bound!", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to bind the specified address and port!", e);
        }
    }

    @Override
    public void close() {
        this.connectedClients.removeIf(client -> {
            client.close();
            return true;
        });
        Channeled.super.close();
        try {
            this.group.shutdownNow();
        }
        catch (IOException e) {
            LOGGER.debug("An IOException occurred when shutting down the AsynchronousChannelGroup!", (Throwable)e);
        }
    }

    @Override
    public AsynchronousServerSocketChannel getChannel() {
        return this.channel;
    }

    public int getNumConnectedClients() {
        return this.connectedClients.size();
    }

    private void queueHelper(Consumer<Client> consumer, Client ... clients) {
        Set toExclude = Collections.newSetFromMap(new IdentityHashMap(clients.length));
        Collections.addAll(toExclude, clients);
        this.connectedClients.stream().filter(client -> !toExclude.contains(client)).forEach(consumer);
    }

    private void queueHelper(Consumer<Client> consumer, Collection<? extends Client> clients) {
        Set toExclude = Collections.newSetFromMap(new IdentityHashMap(clients.size()));
        toExclude.addAll(clients);
        this.connectedClients.stream().filter(client -> !toExclude.contains(client)).forEach(consumer);
    }

    public final void queueToAllExcept(Packet packet, Client ... clients) {
        this.queueHelper(packet::queue, clients);
    }

    public final void queueToAllExcept(Packet packet, Collection<? extends Client> clients) {
        this.queueHelper(packet::queue, clients);
    }

    public final void flushToAllExcept(Client ... clients) {
        this.queueHelper(Client::flush, clients);
    }

    public final void flushToAllExcept(Collection<? extends Client> clients) {
        this.queueHelper(Client::flush, clients);
    }

    public final void queueAndFlushToAllExcept(Packet packet, Client ... clients) {
        this.queueHelper(packet::queueAndFlush, clients);
    }

    public final void queueAndFlushToAllExcept(Packet packet, Collection<? extends Client> clients) {
        this.queueHelper(packet::queueAndFlush, clients);
    }
}

