/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet;

import com.github.pbbl.AbstractBufferPool;
import com.github.pbbl.direct.DirectByteBufferPool;
import com.github.simplenet.AbstractReceiver;
import com.github.simplenet.Channeled;
import com.github.simplenet.packet.Packet;
import com.github.simplenet.utility.IntPair;
import com.github.simplenet.utility.MutableBoolean;
import com.github.simplenet.utility.Pair;
import com.github.simplenet.utility.Utility;
import com.github.simplenet.utility.exposed.cryptography.CryptographicFunction;
import com.github.simplenet.utility.exposed.data.BooleanReader;
import com.github.simplenet.utility.exposed.data.ByteReader;
import com.github.simplenet.utility.exposed.data.CharReader;
import com.github.simplenet.utility.exposed.data.DoubleReader;
import com.github.simplenet.utility.exposed.data.FloatReader;
import com.github.simplenet.utility.exposed.data.IntReader;
import com.github.simplenet.utility.exposed.data.LongReader;
import com.github.simplenet.utility.exposed.data.StringReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.security.GeneralSecurityException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends AbstractReceiver<Runnable>
implements Channeled<AsynchronousSocketChannel>,
BooleanReader,
ByteReader,
CharReader,
IntReader,
FloatReader,
LongReader,
DoubleReader,
StringReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Client.class);
    private final CompletionHandler<Integer, ByteBuffer> packetHandler = new CompletionHandler<Integer, ByteBuffer>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, ByteBuffer buffer) {
            Client client = Client.this;
            DIRECT_BUFFER_POOL.give((Buffer)buffer);
            Queue<Packet> queue = client.outgoingPackets;
            synchronized (queue) {
                ByteBuffer payload = client.packetsToFlush.poll();
                if (payload == null) {
                    client.writeInProgress.set(false);
                    return;
                }
                client.channel.write(payload, payload, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable t, ByteBuffer buffer) {
            Client client = Client.this;
            DIRECT_BUFFER_POOL.give((Buffer)buffer);
            Queue<Packet> queue = client.outgoingPackets;
            synchronized (queue) {
                ByteBuffer discard;
                while ((discard = client.packetsToFlush.poll()) != null) {
                    DIRECT_BUFFER_POOL.give((Buffer)discard);
                }
            }
            client.writeInProgress.set(false);
        }
    };
    private static final AbstractBufferPool<ByteBuffer> DIRECT_BUFFER_POOL = new DirectByteBufferPool();
    private final MutableBoolean inCallback;
    private final AtomicBoolean closing;
    private final AtomicBoolean readInProgress;
    private final AtomicBoolean writeInProgress;
    private final Queue<Packet> outgoingPackets;
    private final Queue<ByteBuffer> packetsToFlush;
    private final Deque<IntPair<Predicate<ByteBuffer>>> stack;
    private final Deque<IntPair<Predicate<ByteBuffer>>> queue;
    private boolean decryptionNoPadding;
    private boolean encryptionNoPadding;
    private Cipher decryptionCipher;
    private Cipher encryptionCipher;
    private CryptographicFunction decryptionFunction;
    private CryptographicFunction encryptionFunction;
    private AsynchronousChannelGroup group;
    private AsynchronousSocketChannel channel;

    public Client() {
        this((AsynchronousSocketChannel)null);
    }

    Client(AsynchronousSocketChannel channel) {
        this.closing = new AtomicBoolean();
        this.inCallback = new MutableBoolean();
        this.readInProgress = new AtomicBoolean();
        this.writeInProgress = new AtomicBoolean();
        this.outgoingPackets = new ArrayDeque<Packet>();
        this.packetsToFlush = new ArrayDeque<ByteBuffer>();
        this.queue = new ArrayDeque<IntPair<Predicate<ByteBuffer>>>();
        this.stack = new ArrayDeque<IntPair<Predicate<ByteBuffer>>>();
        if (channel != null) {
            this.channel = channel;
        }
    }

    protected Client(Client client) {
        super(client);
        this.stack = client.stack;
        this.queue = client.queue;
        this.channel = client.channel;
        this.closing = client.closing;
        this.inCallback = client.inCallback;
        this.packetsToFlush = client.packetsToFlush;
        this.readInProgress = client.readInProgress;
        this.writeInProgress = client.writeInProgress;
        this.outgoingPackets = client.outgoingPackets;
        this.encryptionCipher = client.encryptionCipher;
        this.decryptionCipher = client.decryptionCipher;
        this.encryptionFunction = client.encryptionFunction;
        this.decryptionFunction = client.decryptionFunction;
        this.decryptionNoPadding = client.decryptionNoPadding;
    }

    public final void connect(String address, int port) {
        this.connect(address, port, 30L, TimeUnit.SECONDS, () -> LOGGER.warn("Couldn't connect to the server! Maybe it's offline?"));
    }

    public final void connect(String address, int port, long timeout, TimeUnit unit, Runnable onTimeout) {
        Objects.requireNonNull(address);
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The specified port must be between 0 and 65535!");
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(false);
            thread.setName(thread.getName().replace("Thread", "SimpleNet"));
            return thread;
        }, (runnable, threadPoolExecutor) -> {});
        executor.prestartCoreThread();
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(executor);
            this.channel = AsynchronousSocketChannel.open(this.group);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)8192);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)8192);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)false);
            this.channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open the channel!", e);
        }
        try {
            this.channel.connect(new InetSocketAddress(address, port)).get(timeout, unit);
        }
        catch (AlreadyConnectedException e) {
            throw new IllegalStateException("This client is already connected to a server!", e);
        }
        catch (Exception e) {
            onTimeout.run();
            this.close(false);
            return;
        }
        executor.execute(() -> this.connectListeners.forEach(Runnable::run));
    }

    private void close(boolean waitForWrite) {
        if (this.closing.getAndSet(true)) {
            return;
        }
        this.preDisconnectListeners.forEach(Runnable::run);
        if (waitForWrite) {
            this.flush();
            while (this.writeInProgress.get()) {
                Thread.onSpinWait();
            }
        }
        Channeled.super.close();
        while (this.channel.isOpen()) {
            Thread.onSpinWait();
        }
        this.postDisconnectListeners.forEach(Runnable::run);
        if (this.group != null) {
            try {
                this.group.shutdownNow();
            }
            catch (IOException e) {
                LOGGER.debug("An IOException occurred when shutting down the AsynchronousChannelGroup!", (Throwable)e);
            }
        }
    }

    @Override
    public final void close() {
        this.close(true);
    }

    public final void preDisconnect(Runnable listener) {
        this.preDisconnectListeners.add(listener);
    }

    public final void postDisconnect(Runnable listener) {
        this.postDisconnectListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readUntil(int n, Predicate<ByteBuffer> predicate, ByteOrder order) {
        boolean shouldDecrypt;
        boolean bl = shouldDecrypt = this.decryptionCipher != null;
        if (shouldDecrypt && !this.decryptionNoPadding) {
            int blockSize = this.decryptionCipher.getBlockSize();
            n = Utility.roundUpToNextMultiple(n, blockSize == 0 ? this.decryptionCipher.getOutputSize(n) : blockSize);
        }
        IntPair<Predicate<ByteBuffer>> pair = new IntPair<Predicate<ByteBuffer>>(n, buffer -> predicate.test(buffer.order(order)));
        Deque<IntPair<Predicate<ByteBuffer>>> deque = this.queue;
        synchronized (deque) {
            if (this.inCallback.get()) {
                this.stack.push(pair);
                return;
            }
            this.queue.offerFirst(pair);
            if (!this.readInProgress.getAndSet(true)) {
                ByteBuffer buffer2 = (ByteBuffer)DIRECT_BUFFER_POOL.take(n);
                this.channel.read(buffer2, new Pair<Client, ByteBuffer>(this, buffer2), Listener.INSTANCE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        boolean shouldEncrypt = this.encryptionCipher != null;
        Queue<Packet> queue = this.outgoingPackets;
        synchronized (queue) {
            Packet packet;
            while ((packet = this.outgoingPackets.poll()) != null) {
                Deque<Consumer<ByteBuffer>> queue2 = packet.getQueue();
                ByteBuffer raw = (ByteBuffer)DIRECT_BUFFER_POOL.take(packet.getSize(this));
                for (Consumer<ByteBuffer> input : queue2) {
                    input.accept(raw);
                }
                if (shouldEncrypt) {
                    try {
                        raw = this.encryptionFunction.apply(this.encryptionCipher, raw.flip());
                    }
                    catch (GeneralSecurityException e) {
                        throw new IllegalStateException("An exception occurred whilst encrypting data!", e);
                    }
                }
                raw.flip();
                if (!this.writeInProgress.getAndSet(true)) {
                    this.channel.write(raw, raw, this.packetHandler);
                    continue;
                }
                this.packetsToFlush.offer(raw);
            }
        }
    }

    public final Queue<Packet> getOutgoingPackets() {
        return this.outgoingPackets;
    }

    @Override
    public final AsynchronousSocketChannel getChannel() {
        return this.channel;
    }

    public final Cipher getEncryptionCipher() {
        return this.encryptionCipher;
    }

    public final Cipher getDecryptionCipher() {
        return this.decryptionCipher;
    }

    public final void setEncryptionCipher(Cipher encryptionCipher) {
        this.setEncryption(encryptionCipher, CryptographicFunction.DO_FINAL);
    }

    public final void setEncryption(Cipher encryptionCipher, CryptographicFunction encryptionFunction) {
        this.encryptionCipher = encryptionCipher;
        this.encryptionFunction = encryptionFunction;
        this.encryptionNoPadding = encryptionCipher.getAlgorithm().endsWith("NoPadding");
    }

    public boolean isEncryptionNoPadding() {
        return this.encryptionNoPadding;
    }

    public final void setDecryptionCipher(Cipher decryptionCipher) {
        this.setDecryption(decryptionCipher, CryptographicFunction.DO_FINAL);
    }

    public final void setDecryption(Cipher decryptionCipher, CryptographicFunction decryptionFunction) {
        this.decryptionCipher = decryptionCipher;
        this.decryptionFunction = decryptionFunction;
        this.decryptionNoPadding = decryptionCipher.getAlgorithm().endsWith("NoPadding");
    }

    static class Listener
    implements CompletionHandler<Integer, Pair<Client, ByteBuffer>> {
        static final Listener INSTANCE = new Listener();

        Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, Pair<Client, ByteBuffer> pair) {
            int bytesReceived = result;
            if (bytesReceived == -1) {
                pair.getKey().close(false);
                return;
            }
            Client client = pair.getKey();
            ByteBuffer buffer = pair.getValue().flip();
            Deque<IntPair<Predicate<ByteBuffer>>> deque = client.queue;
            synchronized (deque) {
                int key;
                boolean queueIsEmpty;
                IntPair<Predicate<ByteBuffer>> peek;
                block16: {
                    Deque<IntPair<Predicate<ByteBuffer>>> queue = client.queue;
                    peek = queue.peekLast();
                    if (peek == null) {
                        client.readInProgress.set(false);
                        return;
                    }
                    Deque<IntPair<Predicate<ByteBuffer>>> stack = client.stack;
                    boolean shouldDecrypt = client.decryptionCipher != null;
                    queueIsEmpty = false;
                    client.inCallback.set(true);
                    do {
                        key = peek.getKey();
                        if (buffer.remaining() < key) break block16;
                        ByteBuffer wrappedBuffer = buffer.duplicate().mark().limit(buffer.position() + key);
                        if (shouldDecrypt) {
                            try {
                                wrappedBuffer = client.decryptionFunction.apply(client.decryptionCipher, wrappedBuffer).reset();
                            }
                            catch (Exception e) {
                                throw new IllegalStateException("An exception occurred whilst encrypting data:", e);
                            }
                        }
                        if (!peek.getValue().test(wrappedBuffer)) {
                            queue.pollLast();
                        }
                        if (wrappedBuffer.hasRemaining()) {
                            int remaining = wrappedBuffer.remaining();
                            byte[] decodedData = new byte[Math.min(key, 8)];
                            wrappedBuffer.reset().get(decodedData);
                            LOGGER.warn("A packet has not been read fully! {} byte(s) leftover! First 8 bytes of data: {}", (Object)remaining, (Object)decodedData);
                        }
                        buffer.position(wrappedBuffer.limit());
                        while (!stack.isEmpty()) {
                            queue.offerLast(stack.pop());
                        }
                    } while ((peek = queue.peekLast()) != null);
                    queueIsEmpty = true;
                }
                client.inCallback.set(false);
                if (!queueIsEmpty && buffer.hasRemaining()) {
                    client.channel.read(buffer.position(buffer.limit()).limit(key), pair, this);
                } else {
                    DIRECT_BUFFER_POOL.give((Buffer)buffer);
                    if (queueIsEmpty) {
                        client.readInProgress.set(false);
                    } else {
                        ByteBuffer newBuffer = (ByteBuffer)DIRECT_BUFFER_POOL.take(peek.getKey());
                        client.channel.read(newBuffer, new Pair<Client, ByteBuffer>(client, newBuffer), this);
                    }
                }
            }
        }

        @Override
        public void failed(Throwable t, Pair<Client, ByteBuffer> pair) {
            pair.getKey().close(false);
        }
    }
}

