/*
 * Decompiled with CFR 0.152.
 */
package com.github.simplenet;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

abstract class AbstractReceiver<T> {
    static final int BUFFER_SIZE = 8192;
    final Collection<T> connectListeners;
    final Collection<T> preDisconnectListeners;
    final Collection<T> postDisconnectListeners;

    AbstractReceiver() {
        this.connectListeners = new CopyOnWriteArrayList<T>();
        this.preDisconnectListeners = new CopyOnWriteArrayList<T>();
        this.postDisconnectListeners = new CopyOnWriteArrayList<T>();
    }

    <U extends AbstractReceiver<T>> AbstractReceiver(U receiver) {
        this.connectListeners = receiver.connectListeners;
        this.preDisconnectListeners = receiver.preDisconnectListeners;
        this.postDisconnectListeners = receiver.postDisconnectListeners;
    }

    public final void onConnect(T listener) {
        this.connectListeners.add(listener);
    }
}

