/*
 * Decompiled with CFR 0.152.
 */
package simplenet.utility.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import simplenet.utility.data.DataReader;
import simplenet.utility.exposed.consumer.FloatConsumer;
import simplenet.utility.exposed.predicate.FloatPredicate;

public interface FloatReader
extends DataReader {
    default public float readFloat() throws IllegalStateException {
        return this.readFloat(ByteOrder.BIG_ENDIAN);
    }

    default public float readFloat(ByteOrder order) throws IllegalStateException {
        this.checkIfBlockingInsideCallback();
        CompletableFuture future = new CompletableFuture();
        this.readFloat(future::complete, order);
        return ((Float)this.read(future)).floatValue();
    }

    default public void readFloat(FloatConsumer consumer) {
        this.readFloat(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readFloat(FloatConsumer consumer, ByteOrder order) {
        this.read(4, buffer -> consumer.accept(buffer.getFloat()), order);
    }

    default public void readFloatUntil(FloatPredicate predicate) {
        this.readFloatUntil(predicate, ByteOrder.BIG_ENDIAN);
    }

    default public void readFloatUntil(FloatPredicate predicate, ByteOrder order) {
        this.readUntil(4, buffer -> predicate.test(buffer.getFloat()), order);
    }

    default public void readFloatAlways(FloatConsumer consumer) {
        this.readFloatAlways(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readFloatAlways(FloatConsumer consumer, ByteOrder order) {
        this.readAlways(4, buffer -> consumer.accept(buffer.getFloat()), order);
    }

    default public void readFloats(int n, Consumer<float[]> consumer) {
        this.readFloats(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readFloats(int n, Consumer<float[]> consumer, ByteOrder order) {
        this.read(4 * n, buffer -> this.processFloats((ByteBuffer)buffer, n, consumer), order);
    }

    default public void readFloatsAlways(int n, Consumer<float[]> consumer) {
        this.readFloatsAlways(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readFloatsAlways(int n, Consumer<float[]> consumer, ByteOrder order) {
        this.readAlways(4 * n, buffer -> this.processFloats((ByteBuffer)buffer, n, consumer), order);
    }

    private void processFloats(ByteBuffer buffer, int n, Consumer<float[]> consumer) {
        float[] f = new float[n];
        buffer.asFloatBuffer().get(f);
        consumer.accept(f);
    }
}

