/*
 * Decompiled with CFR 0.152.
 */
package simplenet.utility.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import simplenet.utility.data.DataReader;

public interface DoubleReader
extends DataReader {
    default public double readDouble() throws IllegalStateException {
        return this.readDouble(ByteOrder.BIG_ENDIAN);
    }

    default public double readDouble(ByteOrder order) throws IllegalStateException {
        CompletableFuture future = new CompletableFuture();
        this.readDouble(future::complete, order);
        return (Double)this.read(future);
    }

    default public void readDouble(DoubleConsumer consumer) {
        this.readDouble(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readDouble(DoubleConsumer consumer, ByteOrder order) {
        this.read(8, buffer -> consumer.accept(buffer.getDouble()), order);
    }

    default public void readDoubleUntil(DoublePredicate predicate) {
        this.readDoubleUntil(predicate, ByteOrder.BIG_ENDIAN);
    }

    default public void readDoubleUntil(DoublePredicate predicate, ByteOrder order) {
        this.readUntil(8, buffer -> predicate.test(buffer.getDouble()), order);
    }

    default public void readDoubleAlways(DoubleConsumer consumer) {
        this.readDoubleAlways(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readDoubleAlways(DoubleConsumer consumer, ByteOrder order) {
        this.readAlways(8, buffer -> consumer.accept(buffer.getDouble()), order);
    }

    default public void readDoubles(int n, Consumer<double[]> consumer) {
        this.readDoubles(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readDoubles(int n, Consumer<double[]> consumer, ByteOrder order) {
        this.read(8 * n, buffer -> this.processDoubles((ByteBuffer)buffer, n, consumer), order);
    }

    default public void readDoublesAlways(int n, Consumer<double[]> consumer) {
        this.readDoublesAlways(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readDoublesAlways(int n, Consumer<double[]> consumer, ByteOrder order) {
        this.readAlways(8 * n, buffer -> this.processDoubles((ByteBuffer)buffer, n, consumer), order);
    }

    private void processDoubles(ByteBuffer buffer, int n, Consumer<double[]> consumer) {
        double[] d = new double[n];
        buffer.asDoubleBuffer().get(d);
        consumer.accept(d);
    }
}

