/*
 * Decompiled with CFR 0.152.
 */
package simplenet.utility.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import simplenet.utility.data.DataReader;
import simplenet.utility.exposed.consumer.CharConsumer;
import simplenet.utility.exposed.predicate.CharPredicate;

public interface CharReader
extends DataReader {
    default public char readChar() throws IllegalStateException {
        return this.readChar(ByteOrder.BIG_ENDIAN);
    }

    default public char readChar(ByteOrder order) throws IllegalStateException {
        this.checkIfBlockingInsideCallback();
        CompletableFuture future = new CompletableFuture();
        this.readChar(future::complete, order);
        return ((Character)this.read(future)).charValue();
    }

    default public void readChar(CharConsumer consumer) {
        this.readChar(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readChar(CharConsumer consumer, ByteOrder order) {
        this.read(2, buffer -> consumer.accept(buffer.getChar()), order);
    }

    default public void readCharUntil(CharPredicate predicate) {
        this.readCharUntil(predicate, ByteOrder.BIG_ENDIAN);
    }

    default public void readCharUntil(CharPredicate predicate, ByteOrder order) {
        this.readUntil(2, buffer -> predicate.test(buffer.getChar()), order);
    }

    default public void readCharAlways(CharConsumer consumer) {
        this.readCharAlways(consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readCharAlways(CharConsumer consumer, ByteOrder order) {
        this.readAlways(2, buffer -> consumer.accept(buffer.getChar()), order);
    }

    default public void readChars(int n, Consumer<char[]> consumer) {
        this.readChars(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readChars(int n, Consumer<char[]> consumer, ByteOrder order) {
        this.read(2 * n, buffer -> this.processChars((ByteBuffer)buffer, n, consumer), order);
    }

    default public void readCharsAlways(int n, Consumer<char[]> consumer) {
        this.readCharsAlways(n, consumer, ByteOrder.BIG_ENDIAN);
    }

    default public void readCharsAlways(int n, Consumer<char[]> consumer, ByteOrder order) {
        this.readAlways(2 * n, buffer -> this.processChars((ByteBuffer)buffer, n, consumer), order);
    }

    private void processChars(ByteBuffer buffer, int n, Consumer<char[]> consumer) {
        char[] c = new char[n];
        buffer.asCharBuffer().get(c);
        consumer.accept(c);
    }
}

