/*
 * Decompiled with CFR 0.152.
 */
package simplenet.utility.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import simplenet.utility.data.DataReader;
import simplenet.utility.exposed.consumer.ByteConsumer;
import simplenet.utility.exposed.predicate.BytePredicate;

public interface ByteReader
extends DataReader {
    default public byte readByte() throws IllegalStateException {
        this.checkIfBlockingInsideCallback();
        CompletableFuture future = new CompletableFuture();
        this.readByte(future::complete);
        return (Byte)this.read(future);
    }

    default public void readByte(ByteConsumer consumer) {
        this.read(1, buffer -> consumer.accept(buffer.get()), ByteOrder.BIG_ENDIAN);
    }

    default public void readByteUntil(BytePredicate predicate) {
        this.readUntil(1, buffer -> predicate.test(buffer.get()), ByteOrder.BIG_ENDIAN);
    }

    default public void readByteAlways(ByteConsumer consumer) {
        this.readAlways(1, buffer -> consumer.accept(buffer.get()), ByteOrder.BIG_ENDIAN);
    }

    default public void readBytes(int n, Consumer<byte[]> consumer) {
        this.read(1 * n, buffer -> this.processBytes((ByteBuffer)buffer, n, consumer), ByteOrder.BIG_ENDIAN);
    }

    default public void readBytesAlways(int n, Consumer<byte[]> consumer) {
        this.readAlways(1 * n, buffer -> this.processBytes((ByteBuffer)buffer, n, consumer), ByteOrder.BIG_ENDIAN);
    }

    private void processBytes(ByteBuffer buffer, int n, Consumer<byte[]> consumer) {
        byte[] b = new byte[n];
        buffer.get(b);
        consumer.accept(b);
    }
}

