/*
 * Decompiled with CFR 0.152.
 */
package simplenet.receiver;

import java.util.ArrayList;
import java.util.Collection;

public abstract class Receiver<T> {
    protected final int bufferSize;
    protected final Collection<T> connectListeners;
    protected final Collection<T> preDisconnectListeners;
    protected final Collection<T> postDisconnectListeners;

    protected Receiver(int bufferSize) {
        this.bufferSize = bufferSize;
        this.connectListeners = new ArrayList<T>();
        this.preDisconnectListeners = new ArrayList<T>();
        this.postDisconnectListeners = new ArrayList<T>();
    }

    protected <U extends Receiver<T>> Receiver(U receiver) {
        this.bufferSize = receiver.bufferSize;
        this.connectListeners = receiver.connectListeners;
        this.preDisconnectListeners = receiver.preDisconnectListeners;
        this.postDisconnectListeners = receiver.postDisconnectListeners;
    }

    public final void onConnect(T listener) {
        this.connectListeners.add(listener);
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }
}

