/*
 * Decompiled with CFR 0.152.
 */
package simplenet.packet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import pbbl.ByteBufferPool;
import pbbl.heap.HeapByteBufferPool;
import simplenet.Client;
import simplenet.utility.Utility;

public final class Packet {
    private static final ByteBufferPool HEAP_BUFFER_POOL = new HeapByteBufferPool();
    private boolean prepend;
    private final Deque<byte[]> stack;
    private final Deque<byte[]> queue = new ArrayDeque<byte[]>(4);

    private Packet() {
        this.stack = new ArrayDeque<byte[]>(0);
    }

    public static Packet builder() {
        return new Packet();
    }

    private Packet enqueue(byte[] data) {
        if (this.prepend) {
            this.stack.push(data);
        } else {
            this.queue.offerLast(data);
        }
        return this;
    }

    public Packet putBoolean(boolean b) {
        return this.enqueue(new byte[]{b ? (byte)1 : 0});
    }

    public Packet putByte(int b) {
        return this.enqueue(new byte[]{(byte)b});
    }

    public Packet putBytes(byte ... src) {
        return this.enqueue(src);
    }

    public Packet putChar(char c) {
        return this.putChar(c, ByteOrder.BIG_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet putChar(char c, ByteOrder order) {
        ByteBuffer buffer = HEAP_BUFFER_POOL.take(2);
        byte[] array = buffer.putChar(order == ByteOrder.LITTLE_ENDIAN ? Character.reverseBytes(c) : c).array();
        try {
            Packet packet = this.enqueue(Arrays.copyOfRange(array, 0, 2));
            return packet;
        }
        finally {
            HEAP_BUFFER_POOL.give(buffer);
        }
    }

    public Packet putDouble(double d) {
        return this.putDouble(d, ByteOrder.BIG_ENDIAN);
    }

    public Packet putDouble(double d, ByteOrder order) {
        return this.putLong(Double.doubleToRawLongBits(d), order);
    }

    public Packet putFloat(float f) {
        return this.putFloat(f, ByteOrder.BIG_ENDIAN);
    }

    public Packet putFloat(float f, ByteOrder order) {
        return this.putInt(Float.floatToRawIntBits(f), order);
    }

    public Packet putInt(int i) {
        return this.putInt(i, ByteOrder.BIG_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet putInt(int i, ByteOrder order) {
        ByteBuffer buffer = HEAP_BUFFER_POOL.take(4);
        byte[] array = buffer.putInt(order == ByteOrder.LITTLE_ENDIAN ? Integer.reverseBytes(i) : i).array();
        try {
            Packet packet = this.enqueue(Arrays.copyOfRange(array, 0, 4));
            return packet;
        }
        finally {
            HEAP_BUFFER_POOL.give(buffer);
        }
    }

    public Packet putLong(long l) {
        return this.putLong(l, ByteOrder.BIG_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet putLong(long l, ByteOrder order) {
        ByteBuffer buffer = HEAP_BUFFER_POOL.take(8);
        byte[] array = buffer.putLong(order == ByteOrder.LITTLE_ENDIAN ? Long.reverseBytes(l) : l).array();
        try {
            Packet packet = this.enqueue(Arrays.copyOfRange(array, 0, 8));
            return packet;
        }
        finally {
            HEAP_BUFFER_POOL.give(buffer);
        }
    }

    public Packet putShort(int s) {
        return this.putShort(s, ByteOrder.BIG_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet putShort(int s, ByteOrder order) {
        ByteBuffer buffer = HEAP_BUFFER_POOL.take(2);
        short value = (short)s;
        byte[] array = buffer.putShort(order == ByteOrder.LITTLE_ENDIAN ? Short.reverseBytes(value) : value).array();
        try {
            Packet packet = this.enqueue(Arrays.copyOfRange(array, 0, 2));
            return packet;
        }
        finally {
            HEAP_BUFFER_POOL.give(buffer);
        }
    }

    public Packet putString(String s) {
        return this.putString(s, StandardCharsets.UTF_8, ByteOrder.BIG_ENDIAN);
    }

    public Packet putString(String s, Charset charset) {
        return this.putString(s, charset, ByteOrder.BIG_ENDIAN);
    }

    public Packet putString(String s, Charset charset, ByteOrder order) {
        byte[] bytes = s.getBytes(charset);
        this.putShort(bytes.length, order);
        this.putBytes(bytes);
        return this;
    }

    public Packet prepend(Consumer<Packet> consumer) {
        this.prepend = true;
        consumer.accept(this);
        while (!this.stack.isEmpty()) {
            this.queue.offerFirst(this.stack.pop());
        }
        this.prepend = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends Client> void write(T client) {
        Queue<Packet> clientQueue;
        int size = this.getSize(client);
        if (size > client.getBufferSize()) {
            throw new IllegalStateException("Packet is too large (Size: " + size + ") for client buffer size (Limit: " + client.getBufferSize() + ")");
        }
        Queue<Packet> queue = clientQueue = client.getOutgoingPackets();
        synchronized (clientQueue) {
            clientQueue.offer(this);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @SafeVarargs
    public final <T extends Client> void write(T ... clients) {
        if (clients.length == 0) {
            throw new IllegalArgumentException("You must send this packet to at least one client!");
        }
        for (T client : clients) {
            this.write(client);
        }
    }

    public final void write(Collection<? extends Client> clients) {
        if (clients.isEmpty()) {
            throw new IllegalArgumentException("You must send this packet to at least one client!");
        }
        clients.forEach(this::write);
    }

    public final <T extends Client> void writeAndFlush(T client) {
        this.write(client);
        client.flush();
    }

    @SafeVarargs
    public final <T extends Client> void writeAndFlush(T ... clients) {
        if (clients.length == 0) {
            throw new IllegalArgumentException("You must send this packet to at least one client!");
        }
        for (T client : clients) {
            this.writeAndFlush(client);
        }
    }

    public final void writeAndFlush(Collection<? extends Client> clients) {
        if (clients.isEmpty()) {
            throw new IllegalArgumentException("You must send this packet to at least one client!");
        }
        clients.forEach(this::writeAndFlush);
    }

    public int getSize() {
        return this.getSize(null);
    }

    public <T extends Client> int getSize(T client) {
        Cipher encryption;
        if (client == null || (encryption = client.getEncryptionCipher()) == null) {
            return this.queue.stream().mapToInt(array -> ((byte[])array).length).sum();
        }
        Stream stream = this.queue.stream();
        if (!client.isDecryptionNoPadding()) {
            int blockSize = encryption.getBlockSize();
            return stream.mapToInt(array -> Utility.roundUpToNextMultiple(((byte[])array).length, blockSize)).sum();
        }
        return stream.mapToInt(array -> ((byte[])array).length).sum();
    }

    public Deque<byte[]> getQueue() {
        return this.queue;
    }
}

