/*
 * Decompiled with CFR 0.152.
 */
package simplenet;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import simplenet.Client;
import simplenet.channel.Channeled;
import simplenet.packet.Packet;
import simplenet.receiver.Receiver;
import simplenet.utility.Utility;

public class Server
extends Receiver<Consumer<Client>>
implements Channeled<AsynchronousServerSocketChannel> {
    private final Set<Client> connectedClients = ConcurrentHashMap.newKeySet();
    private final AsynchronousChannelGroup group;
    private final AsynchronousServerSocketChannel channel;

    public Server() throws IllegalStateException {
        this(8192);
    }

    public Server(int bufferSize) throws IllegalStateException {
        this(bufferSize, Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
    }

    public Server(int bufferSize, int numThreads) throws IllegalStateException {
        super(bufferSize);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(false);
            thread.setName(thread.getName().replace("Thread", "SimpleNet"));
            return thread;
        }, (runnable, threadPoolExecutor) -> {});
        executor.prestartAllCoreThreads();
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(executor);
            this.channel = AsynchronousServerSocketChannel.open(this.group);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)bufferSize);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open the channel:", e);
        }
    }

    public void bind(String address, int port) {
        Objects.requireNonNull(address);
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The port must be between 0 and 65535!");
        }
        try {
            this.channel.bind(new InetSocketAddress(address, port));
            this.channel.accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(){

                @Override
                public void completed(AsynchronousSocketChannel channel, Void attachment) {
                    Client client = new Client(Server.this.bufferSize, channel);
                    Server.this.connectedClients.add(client);
                    client.postDisconnect(() -> Server.this.connectedClients.remove(client));
                    Server.this.connectListeners.forEach(consumer -> consumer.accept(client));
                    Server.this.channel.accept(null, this);
                }

                @Override
                public void failed(Throwable t, Void attachment) {
                }
            });
            if (Utility.isDebug()) {
                System.out.printf("Successfully bound to %s:%d!\n", address, port);
            }
        }
        catch (AlreadyBoundException e) {
            throw new IllegalStateException("This server is already bound!", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to bind the server!", e);
        }
    }

    @Override
    public void close() {
        block2: {
            this.connectedClients.removeIf(client -> {
                client.close();
                return true;
            });
            Channeled.super.close();
            try {
                this.group.shutdownNow();
            }
            catch (IOException e) {
                if (!Utility.isDebug()) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public AsynchronousServerSocketChannel getChannel() {
        return this.channel;
    }

    public int getNumConnectedClients() {
        return this.connectedClients.size();
    }

    @SafeVarargs
    private <T extends Client> void writeHelper(Consumer<Client> consumer, T ... clients) {
        Set toExclude = Collections.newSetFromMap(new IdentityHashMap(clients.length));
        Collections.addAll(toExclude, clients);
        this.connectedClients.stream().filter(Predicate.not(toExclude::contains)).forEach(consumer);
    }

    private void writeHelper(Consumer<Client> consumer, Collection<? extends Client> clients) {
        Set toExclude = Collections.newSetFromMap(new IdentityHashMap(clients.size()));
        toExclude.addAll(clients);
        this.connectedClients.stream().filter(Predicate.not(toExclude::contains)).forEach(consumer);
    }

    @SafeVarargs
    public final <T extends Client> void writeToAllExcept(Packet packet, T ... clients) {
        this.writeHelper(packet::write, (Client[])clients);
    }

    public final void writeToAllExcept(Packet packet, Collection<? extends Client> clients) {
        this.writeHelper(packet::write, clients);
    }

    @SafeVarargs
    public final <T extends Client> void flushToAllExcept(T ... clients) {
        this.writeHelper(Client::flush, (Client[])clients);
    }

    public final void flushToAllExcept(Collection<? extends Client> clients) {
        this.writeHelper(Client::flush, clients);
    }

    @SafeVarargs
    public final <T extends Client> void writeAndFlushToAllExcept(Packet packet, T ... clients) {
        this.writeHelper(packet::writeAndFlush, (Client[])clients);
    }

    public final void writeAndFlushToAllExcept(Packet packet, Collection<? extends Client> clients) {
        this.writeHelper(packet::writeAndFlush, clients);
    }
}

