/*
 * Decompiled with CFR 0.152.
 */
package simplenet;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.security.GeneralSecurityException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.crypto.Cipher;
import pbbl.ByteBufferPool;
import pbbl.direct.DirectByteBufferPool;
import simplenet.channel.Channeled;
import simplenet.packet.Packet;
import simplenet.receiver.Receiver;
import simplenet.utility.IntPair;
import simplenet.utility.MutableBoolean;
import simplenet.utility.MutableInt;
import simplenet.utility.Utility;
import simplenet.utility.data.BooleanReader;
import simplenet.utility.data.ByteReader;
import simplenet.utility.data.CharReader;
import simplenet.utility.data.DataReader;
import simplenet.utility.data.DoubleReader;
import simplenet.utility.data.FloatReader;
import simplenet.utility.data.IntReader;
import simplenet.utility.data.LongReader;
import simplenet.utility.data.StringReader;
import simplenet.utility.exposed.cryptography.CryptographicFunction;

public class Client
extends Receiver<Runnable>
implements Channeled<AsynchronousSocketChannel>,
DataReader,
BooleanReader,
ByteReader,
CharReader,
IntReader,
FloatReader,
LongReader,
DoubleReader,
StringReader {
    private final CompletionHandler<Integer, ByteBuffer> packetHandler = new CompletionHandler<Integer, ByteBuffer>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, ByteBuffer buffer) {
            Client client = Client.this;
            DIRECT_BUFFER_POOL.give(buffer);
            Queue<Packet> queue = client.outgoingPackets;
            synchronized (queue) {
                ByteBuffer payload = client.packetsToFlush.poll();
                if (payload == null) {
                    client.writeInProgress.set(false);
                    return;
                }
                client.channel.write(payload, payload, this);
            }
        }

        @Override
        public void failed(Throwable t, ByteBuffer buffer) {
            t.printStackTrace();
        }
    };
    private static final ByteBufferPool DIRECT_BUFFER_POOL = new DirectByteBufferPool();
    private final ByteBuffer buffer;
    private final MutableInt size;
    private final MutableBoolean inCallback;
    private final AtomicBoolean closing;
    private final AtomicBoolean readInProgress;
    private final AtomicBoolean writeInProgress;
    private final Queue<Packet> outgoingPackets;
    private final Queue<ByteBuffer> packetsToFlush;
    private final Deque<IntPair<Predicate<ByteBuffer>>> stack;
    private final Deque<IntPair<Predicate<ByteBuffer>>> queue;
    private boolean decryptionNoPadding;
    private Cipher encryptionCipher;
    private CryptographicFunction encryptionFunction;
    private Cipher decryptionCipher;
    private CryptographicFunction decryptionFunction;
    private AsynchronousChannelGroup group;
    private AsynchronousSocketChannel channel;

    public Client() {
        this(8192);
    }

    public Client(int bufferSize) {
        this(bufferSize, null);
    }

    public Client(int bufferSize, AsynchronousSocketChannel channel) {
        super(bufferSize);
        this.size = new MutableInt();
        this.closing = new AtomicBoolean();
        this.inCallback = new MutableBoolean();
        this.readInProgress = new AtomicBoolean();
        this.writeInProgress = new AtomicBoolean();
        this.outgoingPackets = new ArrayDeque<Packet>();
        this.packetsToFlush = new ArrayDeque<ByteBuffer>();
        this.queue = new ArrayDeque<IntPair<Predicate<ByteBuffer>>>();
        this.stack = new ArrayDeque<IntPair<Predicate<ByteBuffer>>>();
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        if (channel != null) {
            this.channel = channel;
        }
    }

    public Client(Client client) {
        super(client);
        this.size = client.size;
        this.stack = client.stack;
        this.queue = client.queue;
        this.buffer = client.buffer;
        this.channel = client.channel;
        this.closing = client.closing;
        this.inCallback = client.inCallback;
        this.packetsToFlush = client.packetsToFlush;
        this.readInProgress = client.readInProgress;
        this.writeInProgress = client.writeInProgress;
        this.outgoingPackets = client.outgoingPackets;
        this.encryptionCipher = client.encryptionCipher;
        this.decryptionCipher = client.decryptionCipher;
        this.encryptionFunction = client.encryptionFunction;
        this.decryptionFunction = client.decryptionFunction;
        this.decryptionNoPadding = client.decryptionNoPadding;
    }

    public final void connect(String address, int port) {
        this.connect(address, port, 30L, TimeUnit.SECONDS, () -> System.err.println("Couldn't connect to the server! Maybe it's offline?"));
    }

    public final void connect(String address, int port, long timeout, TimeUnit unit, Runnable onTimeout) {
        Objects.requireNonNull(address);
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The specified port must be between 0 and 65535!");
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(false);
            thread.setName(thread.getName().replace("Thread", "SimpleNet"));
            if (Utility.isDebug()) {
                thread.setUncaughtExceptionHandler(($, throwable) -> throwable.printStackTrace());
            }
            return thread;
        }, (runnable, threadPoolExecutor) -> {});
        executor.prestartAllCoreThreads();
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(executor);
            this.channel = AsynchronousSocketChannel.open(this.group);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.bufferSize);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.bufferSize);
            this.channel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)false);
            this.channel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open the channel!", e);
        }
        try {
            this.channel.connect(new InetSocketAddress(address, port)).get(timeout, unit);
        }
        catch (AlreadyConnectedException e) {
            throw new IllegalStateException("This client is already connected to a server!", e);
        }
        catch (Exception e) {
            onTimeout.run();
            this.close();
            return;
        }
        ForkJoinPool.commonPool().execute(() -> this.connectListeners.forEach(Runnable::run));
    }

    @Override
    public final void close() {
        block6: {
            if (this.closing.getAndSet(true)) {
                return;
            }
            this.preDisconnectListeners.forEach(Runnable::run);
            this.flush();
            while (this.writeInProgress.get()) {
                Thread.onSpinWait();
            }
            Channeled.super.close();
            while (this.channel.isOpen()) {
                Thread.onSpinWait();
            }
            this.postDisconnectListeners.forEach(Runnable::run);
            if (this.group != null) {
                try {
                    this.group.shutdownNow();
                }
                catch (IOException e) {
                    if (!Utility.isDebug()) break block6;
                    e.printStackTrace();
                }
            }
        }
    }

    public final void preDisconnect(Runnable listener) {
        this.preDisconnectListeners.add(listener);
    }

    public final void postDisconnect(Runnable listener) {
        this.postDisconnectListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readUntil(int n, Predicate<ByteBuffer> predicate, ByteOrder order) {
        boolean shouldDecrypt;
        boolean bl = shouldDecrypt = this.decryptionCipher != null;
        if (shouldDecrypt && !this.decryptionNoPadding) {
            n = Utility.roundUpToNextMultiple(n, this.decryptionCipher.getBlockSize());
        }
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            IntPair<Predicate<ByteBuffer>> pair = new IntPair<Predicate<ByteBuffer>>(n, buffer -> predicate.test(buffer.order(order)));
            if (this.inCallback.get()) {
                this.stack.push(pair);
                return;
            }
            while (this.size.get() >= n && this.queue.isEmpty() && this.stack.isEmpty()) {
                ByteBuffer wrappedBuffer;
                boolean shouldReturn;
                this.size.add(-n);
                byte[] data = new byte[n];
                this.buffer.order(order).get(data);
                if (shouldDecrypt) {
                    try {
                        data = this.decryptionFunction.apply(this.decryptionCipher, data);
                    }
                    catch (GeneralSecurityException e) {
                        throw new IllegalStateException("An exception occurred whilst decrypting data:", e);
                    }
                }
                boolean bl2 = shouldReturn = !predicate.test(wrappedBuffer = ByteBuffer.wrap(data).order(order));
                if (wrappedBuffer.hasRemaining() && Utility.isDebug()) {
                    System.err.println(wrappedBuffer.remaining() + " byte(s) still need to be read!");
                }
                if (!shouldReturn) continue;
                return;
            }
            this.queue.offerFirst(pair);
            if (!this.readInProgress.getAndSet(true)) {
                this.channel.read(this.buffer.position(this.size.get()), this, Listener.INSTANCE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        int totalBytes = 0;
        boolean shouldEncrypt = this.encryptionCipher != null;
        ArrayDeque<byte[]> queue = new ArrayDeque<byte[]>();
        Queue<Packet> queue2 = this.outgoingPackets;
        synchronized (queue2) {
            Packet packet;
            while ((packet = this.outgoingPackets.poll()) != null) {
                int currentBytes = totalBytes;
                boolean tooBig = (totalBytes += packet.getSize(this)) >= this.bufferSize;
                boolean empty = this.outgoingPackets.isEmpty();
                if (!tooBig || empty) {
                    queue.addAll(packet.getQueue());
                }
                if (!tooBig && !empty) continue;
                ByteBuffer raw = DIRECT_BUFFER_POOL.take(empty ? totalBytes : currentBytes);
                try {
                    byte[] input;
                    while ((input = (byte[])queue.pollFirst()) != null) {
                        raw.put(shouldEncrypt ? this.encryptionFunction.apply(this.encryptionCipher, input) : input);
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalStateException("An exception occurred whilst encrypting data:", e);
                }
                raw.flip();
                queue.addAll(packet.getQueue());
                if (!this.writeInProgress.getAndSet(true)) {
                    this.channel.write(raw, raw, this.packetHandler);
                } else {
                    this.packetsToFlush.offer(raw);
                }
                totalBytes = packet.getSize(this);
            }
        }
    }

    public final Queue<Packet> getOutgoingPackets() {
        return this.outgoingPackets;
    }

    @Override
    public final AsynchronousSocketChannel getChannel() {
        return this.channel;
    }

    public final Cipher getEncryptionCipher() {
        return this.encryptionCipher;
    }

    public final Cipher getDecryptionCipher() {
        return this.decryptionCipher;
    }

    public final void setEncryptionCipher(Cipher encryptionCipher) {
        this.setEncryption(encryptionCipher, Cipher::doFinal);
    }

    public final void setEncryption(Cipher encryptionCipher, CryptographicFunction encryptionFunction) {
        this.encryptionCipher = encryptionCipher;
        this.encryptionFunction = encryptionFunction;
    }

    public final void setDecryptionCipher(Cipher decryptionCipher) {
        this.setDecryption(decryptionCipher, Cipher::doFinal);
    }

    public final void setDecryption(Cipher decryptionCipher, CryptographicFunction decryptionFunction) {
        this.decryptionCipher = decryptionCipher;
        this.decryptionFunction = decryptionFunction;
        this.decryptionNoPadding = decryptionCipher.getAlgorithm().endsWith("NoPadding");
    }

    public boolean isDecryptionNoPadding() {
        return this.decryptionNoPadding;
    }

    static class Listener
    implements CompletionHandler<Integer, Client> {
        static final Listener INSTANCE = new Listener();

        Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, Client client) {
            int bytesReceived = result;
            if (bytesReceived == -1) {
                client.close();
                return;
            }
            ByteBuffer byteBuffer = client.buffer;
            synchronized (byteBuffer) {
                boolean isQueueEmpty;
                ByteBuffer buffer;
                block16: {
                    client.size.add(bytesReceived);
                    buffer = client.buffer.flip();
                    Deque<IntPair<Predicate<ByteBuffer>>> queue = client.queue;
                    IntPair<Predicate<ByteBuffer>> peek = queue.peekLast();
                    if (peek == null) {
                        client.readInProgress.set(false);
                        return;
                    }
                    boolean shouldDecrypt = client.decryptionCipher != null;
                    Deque<IntPair<Predicate<ByteBuffer>>> stack = client.stack;
                    isQueueEmpty = false;
                    client.inCallback.set(true);
                    do {
                        ByteBuffer wrappedBuffer;
                        int key = peek.key;
                        if (client.size.get() < key) break block16;
                        client.size.add(-key);
                        byte[] data = new byte[key];
                        buffer.get(data);
                        if (shouldDecrypt) {
                            try {
                                data = client.decryptionFunction.apply(client.decryptionCipher, data);
                            }
                            catch (Exception e) {
                                throw new IllegalStateException("An exception occurred whilst encrypting data:", e);
                            }
                        }
                        if (!((Predicate)peek.value).test(wrappedBuffer = ByteBuffer.wrap(data))) {
                            queue.pollLast();
                        }
                        if (wrappedBuffer.hasRemaining() && Utility.isDebug()) {
                            System.err.println(wrappedBuffer.remaining() + " byte(s) still need to be read!");
                        }
                        while (!stack.isEmpty()) {
                            queue.offerLast(stack.pop());
                        }
                    } while ((peek = queue.peekLast()) != null);
                    isQueueEmpty = true;
                }
                client.inCallback.set(false);
                if (client.size.get() > 0) {
                    buffer.compact();
                } else {
                    buffer.clear();
                }
                if (isQueueEmpty) {
                    buffer.position(0);
                    client.readInProgress.set(false);
                } else {
                    client.channel.read(buffer, client, this);
                }
            }
        }

        @Override
        public void failed(Throwable t, Client client) {
            client.close();
        }
    }
}

