/*
 * Decompiled with CFR 0.152.
 */
package com.github.pbbl.direct;

import com.github.pbbl.AbstractBufferPool;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public final class DirectFloatBufferPool
extends AbstractBufferPool<FloatBuffer> {
    @Override
    protected FloatBuffer allocate(int capacity) {
        return ByteBuffer.allocateDirect(capacity << 2).asFloatBuffer();
    }

    @Override
    public void give(FloatBuffer buffer) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("A non-direct FloatBuffer cannot be given to a DirectFloatBufferPool!");
        }
        super.give(buffer);
    }
}

