/*
 * Decompiled with CFR 0.152.
 */
package pbbl;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Predicate;

public abstract class ByteBufferPool {
    private final NavigableMap<Integer, Deque<ByteBuffer>> buffers = new TreeMap<Integer, Deque<ByteBuffer>>();

    protected abstract ByteBuffer create(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer take(int n) {
        NavigableMap<Integer, Deque<ByteBuffer>> navigableMap = this.buffers;
        synchronized (navigableMap) {
            Map.Entry<Integer, Deque<ByteBuffer>> entry = this.buffers.ceilingEntry(n);
            if (entry == null) {
                this.buffers.put(n, new ArrayDeque(3));
                return this.create(n);
            }
            Deque<ByteBuffer> deque = entry.getValue();
            if (!deque.isEmpty()) {
                return deque.poll().clear().limit(n);
            }
            return this.buffers.tailMap(n, false).values().stream().filter(Predicate.not(Collection::isEmpty)).map(Deque::poll).findAny().map(buffer -> buffer.clear().limit(n)).orElseGet(() -> this.create(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void give(ByteBuffer buffer) {
        NavigableMap<Integer, Deque<ByteBuffer>> navigableMap = this.buffers;
        synchronized (navigableMap) {
            this.buffers.computeIfAbsent(buffer.capacity(), $ -> new ArrayDeque()).offer(buffer);
        }
    }
}

