/*
 * Decompiled with CFR 0.152.
 */
package com.github.jershell.kbson;

import com.github.jershell.kbson.BsonEncoder;
import com.github.jershell.kbson.FlexibleDecoder;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.InternalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.Serializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.bson.BsonType;
import org.bson.types.Decimal128;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/github/jershell/kbson/BigDecimalSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljava/math/BigDecimal;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "kbson"})
@Serializer(forClass=BigDecimal.class)
public final class BigDecimalSerializer
implements KSerializer<BigDecimal> {
    @NotNull
    public static final BigDecimalSerializer INSTANCE = new BigDecimalSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"BigDecimalSerializer", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

    private BigDecimalSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        BsonEncoder cfr_ignored_0 = (BsonEncoder)encoder;
        ((BsonEncoder)encoder).encodeDecimal128(new Decimal128(value));
    }

    @InternalSerializationApi
    @NotNull
    public BigDecimal deserialize(@NotNull Decoder decoder) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        if (decoder instanceof FlexibleDecoder) {
            BsonType bsonType = ((FlexibleDecoder)decoder).getReader().getCurrentBsonType();
            switch (bsonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[bsonType.ordinal()]) {
                case 1: {
                    bigDecimal = new BigDecimal(decoder.decodeString());
                    break;
                }
                case 2: {
                    bigDecimal = ((FlexibleDecoder)decoder).getReader().readDecimal128().bigDecimalValue();
                    break;
                }
                default: {
                    throw new SerializationException("Unsupported " + ((FlexibleDecoder)decoder).getReader().getCurrentBsonType() + " reading decimal128");
                }
            }
        } else {
            throw new SerializationException("Unknown decoder type");
        }
        BigDecimal bigDecimal2 = bigDecimal;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"{\n                when (\u2026          }\n            }");
        return bigDecimal2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BsonType.values().length];
            nArray[BsonType.STRING.ordinal()] = 1;
            nArray[BsonType.DECIMAL128.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

