/*
 * Decompiled with CFR 0.152.
 */
package com.github.jershell.kbson;

import com.github.jershell.kbson.BsonEncoder;
import com.github.jershell.kbson.BsonFlexibleDecoder;
import com.github.jershell.kbson.Configuration;
import com.github.jershell.kbson.KBsonKt;
import com.github.jershell.kbson.SerializersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.bson.AbstractBsonReader;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u000fJ'\u0010\u0010\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014J'\u0010\u0010\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0017\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0018\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000e\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/github/jershell/kbson/KBson;", "Lkotlinx/serialization/SerialFormat;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "configuration", "Lcom/github/jershell/kbson/Configuration;", "(Lkotlinx/serialization/modules/SerializersModule;Lcom/github/jershell/kbson/Configuration;)V", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "dump", "", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "obj", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "load", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "doc", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "Lorg/bson/BsonDocument;", "(Lkotlinx/serialization/DeserializationStrategy;Lorg/bson/BsonDocument;)Ljava/lang/Object;", "parse", "stringify", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lorg/bson/BsonDocument;", "Companion", "kbson"})
public final class KBson
implements SerialFormat {
    @NotNull
    private final SerializersModule serializersModule;
    private final Configuration configuration;
    @NotNull
    private static final KBson default;
    public static final Companion Companion;

    @NotNull
    public final <T> BsonDocument stringify(@NotNull SerializationStrategy<? super T> serializer, T obj) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        BsonDocument doc = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(doc);
        serializer.serialize((Encoder)new BsonEncoder((BsonWriter)writer, this.getSerializersModule(), this.configuration), obj);
        writer.flush();
        return doc;
    }

    public final <T> T parse(@NotNull DeserializationStrategy<T> deserializer, @NotNull BsonDocument doc) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        BsonReader bsonReader = doc.asBsonReader();
        if (bsonReader == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bson.AbstractBsonReader");
        }
        return (T)new BsonFlexibleDecoder((AbstractBsonReader)bsonReader, this.getSerializersModule(), this.configuration, null, 8, null).decodeSerializableValue(deserializer);
    }

    public final <T> T load(@NotNull DeserializationStrategy<T> deserializer, @NotNull byte[] doc) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        BsonReader bsonReader = new RawBsonDocument(doc).asBsonReader();
        if (bsonReader == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bson.AbstractBsonReader");
        }
        return (T)new BsonFlexibleDecoder((AbstractBsonReader)bsonReader, this.getSerializersModule(), this.configuration, null, 8, null).decodeSerializableValue(deserializer);
    }

    public final <T> T load(@NotNull DeserializationStrategy<T> deserializer, @NotNull BsonDocument doc) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        BsonReader bsonReader = doc.asBsonReader();
        if (bsonReader == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bson.AbstractBsonReader");
        }
        return (T)new BsonFlexibleDecoder((AbstractBsonReader)bsonReader, this.getSerializersModule(), this.configuration, null, 8, null).decodeSerializableValue(deserializer);
    }

    @NotNull
    public final <T> byte[] dump(@NotNull SerializationStrategy<? super T> serializer, T obj) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        return KBsonKt.toByteArray(this.stringify(serializer, obj));
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public KBson(@NotNull SerializersModule serializersModule, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.serializersModule = serializersModule;
        this.configuration = configuration;
    }

    public /* synthetic */ KBson(SerializersModule serializersModule, Configuration configuration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            serializersModule = SerializersKt.getDefaultModule();
        }
        if ((n & 2) != 0) {
            configuration = new Configuration(false, null, false, 7, null);
        }
        this(serializersModule, configuration);
    }

    public KBson() {
        this(null, null, 3, null);
    }

    static {
        Companion = new Companion(null);
        default = new KBson(null, null, 3, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/jershell/kbson/KBson$Companion;", "", "()V", "default", "Lcom/github/jershell/kbson/KBson;", "getDefault", "()Lcom/github/jershell/kbson/KBson;", "kbson"})
    public static final class Companion {
        @NotNull
        public final KBson getDefault() {
            return default;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

