/*
 * Decompiled with CFR 0.152.
 */
package com.github.javalbert.reflection;

import com.github.javalbert.asm.ClassWriter;
import com.github.javalbert.asm.Handle;
import com.github.javalbert.asm.Label;
import com.github.javalbert.asm.MethodVisitor;
import com.github.javalbert.asm.Type;
import com.github.javalbert.bytecode.utils.AsmUtils;
import com.github.javalbert.reflection.AccessClassLoader;
import com.github.javalbert.reflection.ClassAccess;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassAccessFactory<T> {
    private static final Map<Class, ClassAccess> CLASS_ACCESS_MAP = new WeakHashMap<Class, ClassAccess>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassAccessFactory.class);
    private static final int MAX_METHOD_ACCESS_PARAMETER_COUNT = 22;
    private static final String MEMBER_TYPE_FIELD = "field";
    private static final String MEMBER_TYPE_PROPERTY = "property";
    private final List<PropertyInfo> accessorInfoList = new ArrayList<PropertyInfo>();
    private String classAccessInternalName;
    private String classAccessTypeDescriptor;
    private String classTypeDescriptor;
    private final Class<T> clazz;
    private final ClassWriter cw;
    private final List<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
    private String internalName;
    private final List<MethodInfo> methodInfoList = new ArrayList<MethodInfo>();
    private final List<PropertyInfo> mutatorInfoList = new ArrayList<PropertyInfo>();
    private MethodVisitor mv;
    private final Map<Integer, List<MethodInfo>> paramCountMethodsMap = new HashMap<Integer, List<MethodInfo>>();
    private final List<PropertyInfo> propertyInfoList = new ArrayList<PropertyInfo>();
    private final Map<String, List<PropertyInfo>> typeToAccessorsMap = new HashMap<String, List<PropertyInfo>>();
    private final Map<String, List<FieldInfo>> typeToFieldsMap = new HashMap<String, List<FieldInfo>>();
    private final Map<String, List<PropertyInfo>> typeToMutatorsMap = new HashMap<String, List<PropertyInfo>>();

    public static <T> ClassAccess<T> get(Class<T> clazz) {
        if (ClassAccess.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("should not get class access recursively");
        }
        try {
            return ClassAccessFactory.getInstance(clazz);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while trying to get ClassAccess for " + clazz, e);
            throw new RuntimeException(e);
        }
    }

    private static Class<?> createClassAccessClass(Class<?> clazz) throws ClassNotFoundException {
        String className = ClassAccessFactory.getClassNameOfClassAccessFor(clazz);
        try {
            return AccessClassLoader.get(clazz).loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            new ClassAccessFactory(clazz).buildClassAccessClass();
            return AccessClassLoader.get(clazz).loadClass(className);
        }
    }

    private static String getClassNameOfClassAccessFor(Class<?> clazz) {
        return clazz.getName() + "$" + clazz.getSimpleName() + "ClassAccess";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> ClassAccess<T> getInstance(Class<T> clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassAccess classAccess = CLASS_ACCESS_MAP.get(clazz);
        if (classAccess == null) {
            Map<Class, ClassAccess> map = CLASS_ACCESS_MAP;
            synchronized (map) {
                classAccess = CLASS_ACCESS_MAP.get(clazz);
                if (classAccess == null) {
                    Class<T> classAccessClass = ClassAccessFactory.createClassAccessClass(clazz);
                    classAccess = (ClassAccess)classAccessClass.newInstance();
                    CLASS_ACCESS_MAP.put(clazz, classAccess);
                }
            }
        }
        return classAccess;
    }

    private static Label[] getTableSwitchLabelsForAccess(Label defaultCaseLabel, List<? extends MemberInfo> members) {
        return AsmUtils.getTableSwitchLabels(defaultCaseLabel, members.stream().mapToInt(m -> m.memberIndex).toArray());
    }

    private static boolean isDescriptorDoubleOrLong(String descriptor) {
        return descriptor.equals(Type.DOUBLE_TYPE.getDescriptor()) || descriptor.equals(Type.LONG_TYPE.getDescriptor());
    }

    private static Label[] newLabelArray(int size) {
        Label[] labels = new Label[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = new Label();
        }
        return labels;
    }

    private static void setAccessible(AccessibleObject object) {
        object.setAccessible(true);
    }

    private static boolean useTableSwitch(List<? extends MemberInfo> members) {
        return AsmUtils.useTableSwitch(members.stream().mapToInt(m -> m.memberIndex).toArray());
    }

    private ClassAccessFactory(Class<T> clazz) {
        this.clazz = clazz;
        this.initializePropertyDescriptors();
        this.initializeFields();
        this.initializeMethods();
        this.cw = new ClassWriter(0);
    }

    void buildClassAccessClass() {
        this.visitClass();
        AsmUtils.visitDefaultConstructor(this.cw, this.classAccessTypeDescriptor);
        this.visitIndexMethod(MEMBER_TYPE_FIELD, this.getMemberIndexSwitchCases(this.fieldInfoList));
        this.visitFieldAccessMethods();
        this.visitIndexMethod(MEMBER_TYPE_PROPERTY, this.getMemberIndexSwitchCases(this.propertyInfoList));
        this.visitPropertyAccessMethods();
        this.visitMethodIndexMethod();
        this.visitMethodAccessMethods();
        this.cw.visitEnd();
        AccessClassLoader.get(this.clazz).defineClass(ClassAccessFactory.getClassNameOfClassAccessFor(this.clazz), this.cw.toByteArray());
    }

    private void addFieldInfo(FieldInfo fieldInfo) {
        String key = fieldInfo.type.getName();
        List<FieldInfo> fieldsOfType = this.typeToFieldsMap.get(key);
        if (fieldsOfType == null) {
            fieldsOfType = new ArrayList<FieldInfo>();
            this.typeToFieldsMap.put(key, fieldsOfType);
        }
        fieldsOfType.add(fieldInfo);
        this.fieldInfoList.add(fieldInfo);
    }

    private void addMethodInfo(MethodInfo methodInfo) {
        List<MethodInfo> methodsWithParamCount = this.paramCountMethodsMap.get(methodInfo.parameterCount);
        if (methodsWithParamCount == null) {
            methodsWithParamCount = new ArrayList<MethodInfo>();
            this.paramCountMethodsMap.put(methodInfo.parameterCount, methodsWithParamCount);
        }
        methodsWithParamCount.add(methodInfo);
        this.methodInfoList.add(methodInfo);
    }

    private void addPropertyInfo(PropertyInfo propertyInfo) {
        String key = propertyInfo.type.getName();
        if (propertyInfo.readMethodName != null) {
            List<PropertyInfo> accessorsOfType = this.typeToAccessorsMap.get(key);
            if (accessorsOfType == null) {
                accessorsOfType = new ArrayList<PropertyInfo>();
                this.typeToAccessorsMap.put(key, accessorsOfType);
            }
            accessorsOfType.add(propertyInfo);
            this.accessorInfoList.add(propertyInfo);
        }
        if (propertyInfo.writeMethodName != null) {
            List<PropertyInfo> mutatorsOfType = this.typeToMutatorsMap.get(key);
            if (mutatorsOfType == null) {
                mutatorsOfType = new ArrayList<PropertyInfo>();
                this.typeToMutatorsMap.put(key, mutatorsOfType);
            }
            mutatorsOfType.add(propertyInfo);
            this.mutatorInfoList.add(propertyInfo);
        }
        this.propertyInfoList.add(propertyInfo);
    }

    private void checkCast(Castable castable) {
        String internalNameOfCast = castable.getInternalName();
        if (castable.getType().isPrimitive()) {
            Class<?> wrapperType = ClassUtils.primitiveToWrapper(castable.getType());
            internalNameOfCast = Type.getInternalName(wrapperType);
        }
        this.mv.visitTypeInsn(192, internalNameOfCast);
        if (castable.getType().isPrimitive()) {
            this.mv.visitMethodInsn(182, internalNameOfCast, castable.getType().getName() + "Value", "()" + castable.getDescriptor(), false);
        }
    }

    private List<StringCaseReturnIndex> getMemberIndexSwitchCases(List<? extends MemberInfo> memberInfoList) {
        ArrayList<StringCaseReturnIndex> memberIndexSwitchCases = new ArrayList<StringCaseReturnIndex>();
        for (int i = 0; i < memberInfoList.size(); ++i) {
            memberIndexSwitchCases.add(new StringCaseReturnIndex(memberInfoList.get((int)i).name, i));
        }
        return memberIndexSwitchCases;
    }

    private String getMethodAccessMethodDescriptor(int parameterCount) {
        return this.getMethodAccessMethodDescriptor(parameterCount, this.classTypeDescriptor);
    }

    private String getMethodAccessMethodDescriptor(int parameterCount, String typeDescriptor) {
        StringBuilder desc = new StringBuilder("(" + typeDescriptor + "I");
        for (int i = 0; i < parameterCount; ++i) {
            desc.append("Ljava/lang/Object;");
        }
        return desc.append(")Ljava/lang/Object;").toString();
    }

    private List<MethodNameReturnIndex> getMethodIndexSwitchCases() {
        ArrayList<MethodNameReturnIndex> methodIndices = new ArrayList<MethodNameReturnIndex>();
        HashMap<String, ArrayList<MethodInfo>> overloadedMap = new HashMap<String, ArrayList<MethodInfo>>();
        for (int i = 0; i < this.methodInfoList.size(); ++i) {
            MethodInfo methodInfo = this.methodInfoList.get(i);
            ArrayList<MethodInfo> overloadedMethods = (ArrayList<MethodInfo>)overloadedMap.get(methodInfo.name);
            if (overloadedMethods == null) {
                overloadedMethods = new ArrayList<MethodInfo>();
                overloadedMap.put(methodInfo.name, overloadedMethods);
                overloadedMethods.add(methodInfo);
                methodIndices.add(new MethodNameReturnIndex(overloadedMethods));
                continue;
            }
            overloadedMethods.add(methodInfo);
        }
        return methodIndices;
    }

    private void initializeFields() {
        List fields = Arrays.stream(this.clazz.getDeclaredFields()).sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            ClassAccessFactory.setAccessible(field);
            this.addFieldInfo(new FieldInfo(field, i));
        }
    }

    private void initializeMethods() {
        List methods = Arrays.stream(this.clazz.getDeclaredMethods()).sorted((a, b) -> {
            int compareMethodName = a.getName().compareTo(b.getName());
            if (compareMethodName != 0) {
                return compareMethodName;
            }
            Class<?>[] aparams = a.getParameterTypes();
            Class<?>[] bparams = b.getParameterTypes();
            int len = Math.min(aparams.length, bparams.length);
            for (int i = 0; i < len; ++i) {
                int compareParamType = aparams[i].getName().compareTo(bparams[i].getName());
                if (compareParamType == 0) continue;
                return compareParamType;
            }
            return Integer.compare(aparams.length, bparams.length);
        }).collect(Collectors.toList());
        for (int i = 0; i < methods.size(); ++i) {
            Method method = (Method)methods.get(i);
            ClassAccessFactory.setAccessible(method);
            this.addMethodInfo(new MethodInfo(method, i));
        }
    }

    private void initializePropertyDescriptors() {
        List propertyDescriptors = Collections.EMPTY_LIST;
        try {
            BeanInfo info = Introspector.getBeanInfo(this.clazz);
            propertyDescriptors = Collections.unmodifiableList(Arrays.stream(info.getPropertyDescriptors()).filter(prop -> !prop.getName().equals("class")).collect(Collectors.toList()));
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < propertyDescriptors.size(); ++i) {
            this.addPropertyInfo(new PropertyInfo((PropertyDescriptor)propertyDescriptors.get(i), i));
        }
    }

    private void visitAccessGetter(List<? extends AssignableInfo> memberInfoList, AccessInfo accessInfo) {
        Label[] labels;
        this.mv = this.cw.visitMethod(1, accessInfo.getMethodName, "(" + this.classTypeDescriptor + "I)" + accessInfo.descriptor, null, null);
        this.mv.visitCode();
        Label firstLabel = new Label();
        this.mv.visitLabel(firstLabel);
        this.mv.visitVarInsn(21, 2);
        Label defaultCaseLabel = new Label();
        if (memberInfoList == null || memberInfoList.isEmpty()) {
            this.mv.visitInsn(87);
            this.mv.visitLabel(defaultCaseLabel);
            this.visitAccessGetterLastPart(accessInfo.memberType, firstLabel);
            return;
        }
        boolean useTableSwitch = ClassAccessFactory.useTableSwitch(memberInfoList);
        Label[] labelArray = labels = useTableSwitch ? ClassAccessFactory.getTableSwitchLabelsForAccess(defaultCaseLabel, memberInfoList) : ClassAccessFactory.newLabelArray(memberInfoList.size());
        if (useTableSwitch) {
            this.mv.visitTableSwitchInsn(memberInfoList.get((int)0).memberIndex, memberInfoList.get((int)(memberInfoList.size() - 1)).memberIndex, defaultCaseLabel, labels);
        } else {
            this.mv.visitLookupSwitchInsn(defaultCaseLabel, memberInfoList.stream().mapToInt(f -> f.memberIndex).toArray(), labels);
        }
        for (int i = 0; i < memberInfoList.size(); ++i) {
            MemberInfo memberInfo = memberInfoList.get(i);
            this.mv.visitLabel(labels[i]);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitVarInsn(25, 1);
            switch (accessInfo.memberType) {
                case "field": {
                    this.mv.visitFieldInsn(((FieldInfo)memberInfo).getFieldOpcode, this.internalName, memberInfo.name, accessInfo.descriptor);
                    break;
                }
                case "property": {
                    this.mv.visitMethodInsn(182, this.internalName, ((PropertyInfo)memberInfo).readMethodName, "()" + accessInfo.descriptor, false);
                }
            }
            this.mv.visitInsn(accessInfo.returnOpcode);
        }
        this.mv.visitLabel(defaultCaseLabel);
        this.mv.visitFrame(3, 0, null, 0, null);
        this.visitAccessGetterLastPart(accessInfo.memberType, firstLabel);
    }

    private void visitAccessGetterBridge(AccessInfo accessInfo) {
        this.visitAccessGetterBridge(accessInfo.getMethodName, accessInfo.descriptor, accessInfo.returnOpcode);
    }

    private void visitAccessGetterBridge(String methodName, String returnTypeDescriptor, int returnOpcode) {
        this.mv = this.cw.visitMethod(4161, methodName, "(Ljava/lang/Object;I)" + returnTypeDescriptor, null, null);
        this.mv.visitCode();
        this.mv.visitLabel(new Label());
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitTypeInsn(192, this.internalName);
        this.mv.visitVarInsn(21, 2);
        this.mv.visitMethodInsn(182, this.classAccessInternalName, methodName, "(" + this.classTypeDescriptor + "I)" + returnTypeDescriptor, false);
        this.mv.visitInsn(returnOpcode);
        this.mv.visitMaxs(3, 3);
        this.mv.visitEnd();
    }

    private void visitAccessGetterLastPart(String memberType, Label firstLabel) {
        this.mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(187, "java/lang/StringBuilder");
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn("No " + memberType + " with index: ");
        this.mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitVarInsn(21, 2);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        this.mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitInsn(191);
        Label lastLabel = new Label();
        this.mv.visitLabel(lastLabel);
        this.mv.visitLocalVariable("this", this.classAccessTypeDescriptor, null, firstLabel, lastLabel, 0);
        this.mv.visitLocalVariable("obj", this.classTypeDescriptor, null, firstLabel, lastLabel, 1);
        this.mv.visitLocalVariable(memberType + "Index", "I", null, firstLabel, lastLabel, 2);
        this.mv.visitMaxs(5, 3);
        this.mv.visitEnd();
    }

    private void visitAccessSetter(List<? extends AssignableInfo> memberInfoList, AccessInfo accessInfo) {
        Label[] labels;
        this.mv = this.cw.visitMethod(1, accessInfo.setMethodName, "(" + this.classTypeDescriptor + "I" + accessInfo.descriptor + ")V", null, null);
        this.mv.visitCode();
        Label firstLabel = new Label();
        this.mv.visitLabel(firstLabel);
        this.mv.visitVarInsn(21, 2);
        Label defaultCaseLabel = new Label();
        if (memberInfoList == null || memberInfoList.isEmpty()) {
            this.mv.visitInsn(87);
            this.mv.visitLabel(defaultCaseLabel);
            this.visitAccessSetterLastPart(accessInfo.memberType, accessInfo.descriptor, firstLabel, null);
            return;
        }
        boolean useTableSwitch = ClassAccessFactory.useTableSwitch(memberInfoList);
        Label[] labelArray = labels = useTableSwitch ? ClassAccessFactory.getTableSwitchLabelsForAccess(defaultCaseLabel, memberInfoList) : ClassAccessFactory.newLabelArray(memberInfoList.size());
        if (useTableSwitch) {
            this.mv.visitTableSwitchInsn(memberInfoList.get((int)0).memberIndex, memberInfoList.get((int)(memberInfoList.size() - 1)).memberIndex, defaultCaseLabel, labels);
        } else {
            this.mv.visitLookupSwitchInsn(defaultCaseLabel, memberInfoList.stream().mapToInt(f -> f.memberIndex).toArray(), labels);
        }
        Label breakLabel = new Label();
        for (int i = 0; i < memberInfoList.size(); ++i) {
            MemberInfo memberInfo = memberInfoList.get(i);
            this.mv.visitLabel(labels[i]);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(accessInfo.loadOpcode, 3);
            switch (accessInfo.memberType) {
                case "field": {
                    this.mv.visitFieldInsn(((FieldInfo)memberInfo).setFieldOpcode, this.internalName, memberInfo.name, accessInfo.descriptor);
                    break;
                }
                case "property": {
                    this.mv.visitMethodInsn(182, this.internalName, ((PropertyInfo)memberInfo).writeMethodName, "(" + accessInfo.descriptor + ")V", false);
                }
            }
            this.mv.visitLabel(new Label());
            this.mv.visitJumpInsn(167, breakLabel);
        }
        this.mv.visitLabel(defaultCaseLabel);
        this.mv.visitFrame(3, 0, null, 0, null);
        this.visitAccessSetterLastPart(accessInfo.memberType, accessInfo.descriptor, firstLabel, breakLabel);
    }

    private void visitAccessSetterBridge(AccessInfo accessInfo) {
        this.visitAccessSetterBridge(accessInfo.setMethodName, accessInfo.loadOpcode, accessInfo.descriptor);
    }

    private void visitAccessSetterBridge(String methodName, int loadOpcode, String descriptor) {
        this.mv = this.cw.visitMethod(4161, methodName, "(Ljava/lang/Object;I" + descriptor + ")V", null, null);
        this.mv.visitCode();
        this.mv.visitLabel(new Label());
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitTypeInsn(192, this.internalName);
        this.mv.visitVarInsn(21, 2);
        this.mv.visitVarInsn(loadOpcode, 3);
        this.mv.visitMethodInsn(182, this.classAccessInternalName, methodName, "(" + this.classTypeDescriptor + "I" + descriptor + ")V", false);
        this.mv.visitInsn(177);
        if (ClassAccessFactory.isDescriptorDoubleOrLong(descriptor)) {
            this.mv.visitMaxs(5, 5);
        } else {
            this.mv.visitMaxs(4, 4);
        }
        this.mv.visitEnd();
    }

    private void visitAccessSetterLastPart(String memberType, String fieldDescriptor, Label firstLabel, Label breakLabel) {
        this.mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(187, "java/lang/StringBuilder");
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn("No " + memberType + " with index: ");
        this.mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitVarInsn(21, 2);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        this.mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitInsn(191);
        if (breakLabel != null) {
            this.mv.visitLabel(breakLabel);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitInsn(177);
        }
        Label lastLabel = new Label();
        this.mv.visitLabel(lastLabel);
        this.mv.visitLocalVariable("this", this.classAccessTypeDescriptor, null, firstLabel, lastLabel, 0);
        this.mv.visitLocalVariable("obj", this.classTypeDescriptor, null, firstLabel, lastLabel, 1);
        this.mv.visitLocalVariable(memberType + "Index", "I", null, firstLabel, lastLabel, 2);
        this.mv.visitLocalVariable("x", fieldDescriptor, null, firstLabel, lastLabel, 3);
        this.mv.visitMaxs(5, ClassAccessFactory.isDescriptorDoubleOrLong(fieldDescriptor) ? 5 : 4);
        this.mv.visitEnd();
    }

    private void visitClass() {
        this.internalName = Type.getInternalName(this.clazz);
        String classAccessSimpleName = this.clazz.getSimpleName() + "ClassAccess";
        this.classAccessInternalName = this.internalName + "$" + classAccessSimpleName;
        this.cw.visit(52, 33, this.classAccessInternalName, this.internalName, "sun/reflect/MagicAccessorImpl", new String[]{Type.getInternalName(ClassAccess.class)});
        this.cw.visitSource(this.clazz.getSimpleName() + ".java", null);
        this.cw.visitInnerClass(this.classAccessInternalName, this.internalName, classAccessSimpleName, 9);
        this.classAccessTypeDescriptor = "L" + this.classAccessInternalName + ";";
        this.classTypeDescriptor = "L" + this.internalName + ";";
    }

    private void visitFieldAccessMethods() {
        List<AccessInfo> fieldAccessInfoList = Collections.unmodifiableList(Arrays.asList(AccessInfo.forPrimitive(MEMBER_TYPE_FIELD, Type.BOOLEAN_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_FIELD, Type.BYTE_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_FIELD, Type.CHAR_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_FIELD, Type.DOUBLE_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_FIELD, Type.FLOAT_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_FIELD, Type.INT_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_FIELD, Type.LONG_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_FIELD, Type.SHORT_TYPE), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_FIELD, Boolean.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_FIELD, Byte.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_FIELD, Character.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_FIELD, Double.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_FIELD, Float.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_FIELD, Integer.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_FIELD, Long.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_FIELD, Short.class), AccessInfo.forReferenceType(MEMBER_TYPE_FIELD, BigDecimal.class), AccessInfo.forReferenceType(MEMBER_TYPE_FIELD, Date.class), AccessInfo.forReferenceType(MEMBER_TYPE_FIELD, LocalDate.class), AccessInfo.forReferenceType(MEMBER_TYPE_FIELD, LocalDateTime.class), AccessInfo.forReferenceType(MEMBER_TYPE_FIELD, String.class)));
        for (int i = 0; i < fieldAccessInfoList.size(); ++i) {
            AccessInfo fieldAccessInfo = fieldAccessInfoList.get(i);
            List<FieldInfo> fieldInfoList = this.typeToFieldsMap.get(fieldAccessInfo.className);
            this.visitAccessGetter(fieldInfoList, fieldAccessInfo);
            this.visitAccessGetterBridge(fieldAccessInfo);
            this.visitAccessSetter(fieldInfoList, fieldAccessInfo);
            this.visitAccessSetterBridge(fieldAccessInfo);
        }
        this.visitGeneralAccessGetter("getField", MEMBER_TYPE_FIELD, this.fieldInfoList);
        this.visitAccessGetterBridge("getField", "Ljava/lang/Object;", 176);
        this.visitGeneralAccessSetter("setField", MEMBER_TYPE_FIELD, this.fieldInfoList);
        this.visitAccessSetterBridge("setField", 25, "Ljava/lang/Object;");
    }

    private void visitGeneralAccessGetter(String methodName, String memberType, List<? extends AssignableInfo> memberInfoList) {
        this.mv = this.cw.visitMethod(1, methodName, "(" + this.classTypeDescriptor + "I)Ljava/lang/Object;", null, null);
        this.mv.visitCode();
        Label firstLabel = new Label();
        this.mv.visitLabel(firstLabel);
        this.mv.visitVarInsn(21, 2);
        Label defaultCaseLabel = new Label();
        if (memberInfoList == null || memberInfoList.isEmpty()) {
            this.mv.visitInsn(87);
            this.mv.visitLabel(defaultCaseLabel);
            this.visitAccessGetterLastPart(memberType, firstLabel);
            return;
        }
        Label[] labels = ClassAccessFactory.getTableSwitchLabelsForAccess(defaultCaseLabel, memberInfoList);
        this.mv.visitTableSwitchInsn(memberInfoList.get((int)0).memberIndex, memberInfoList.get((int)(memberInfoList.size() - 1)).memberIndex, defaultCaseLabel, labels);
        for (int i = 0; i < memberInfoList.size(); ++i) {
            AssignableInfo member = memberInfoList.get(i);
            this.mv.visitLabel(labels[i]);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitVarInsn(25, 1);
            switch (memberType) {
                case "field": {
                    this.mv.visitFieldInsn(((FieldInfo)member).getFieldOpcode, this.internalName, member.name, member.descriptor);
                    break;
                }
                case "property": {
                    this.mv.visitMethodInsn(182, this.internalName, ((PropertyInfo)member).readMethodName, "()" + member.descriptor, false);
                }
            }
            if (member.type.isPrimitive()) {
                Class<?> wrapperType = ClassUtils.primitiveToWrapper(member.type);
                this.mv.visitMethodInsn(184, Type.getInternalName(wrapperType), "valueOf", "(" + member.descriptor + ")" + Type.getDescriptor(wrapperType), false);
            }
            this.mv.visitInsn(176);
        }
        this.mv.visitLabel(defaultCaseLabel);
        this.mv.visitFrame(3, 0, null, 0, null);
        this.visitAccessGetterLastPart(memberType, firstLabel);
    }

    private void visitGeneralAccessSetter(String methodName, String memberType, List<? extends AssignableInfo> memberInfoList) {
        this.mv = this.cw.visitMethod(1, methodName, "(" + this.classTypeDescriptor + "ILjava/lang/Object;)V", null, null);
        this.mv.visitCode();
        Label firstLabel = new Label();
        this.mv.visitLabel(firstLabel);
        this.mv.visitVarInsn(21, 2);
        Label defaultCaseLabel = new Label();
        if (memberInfoList == null || memberInfoList.isEmpty()) {
            this.mv.visitInsn(87);
            this.mv.visitLabel(defaultCaseLabel);
            this.visitAccessSetterLastPart(memberType, "Ljava/lang/Object;", firstLabel, null);
            return;
        }
        Label[] labels = ClassAccessFactory.getTableSwitchLabelsForAccess(defaultCaseLabel, memberInfoList);
        this.mv.visitTableSwitchInsn(memberInfoList.get((int)0).memberIndex, memberInfoList.get((int)(memberInfoList.size() - 1)).memberIndex, defaultCaseLabel, labels);
        Label breakLabel = new Label();
        for (int i = 0; i < memberInfoList.size(); ++i) {
            AssignableInfo member = memberInfoList.get(i);
            this.mv.visitLabel(labels[i]);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(25, 3);
            this.checkCast(member);
            switch (memberType) {
                case "field": {
                    this.mv.visitFieldInsn(((FieldInfo)member).setFieldOpcode, this.internalName, member.name, member.descriptor);
                    break;
                }
                case "property": {
                    this.mv.visitMethodInsn(182, this.internalName, ((PropertyInfo)member).writeMethodName, "(" + member.descriptor + ")V", false);
                }
            }
            this.mv.visitLabel(new Label());
            this.mv.visitJumpInsn(167, breakLabel);
        }
        this.mv.visitLabel(defaultCaseLabel);
        this.mv.visitFrame(3, 0, null, 0, null);
        this.visitAccessSetterLastPart(memberType, "Ljava/lang/Object;", firstLabel, breakLabel);
    }

    private void visitIndexMethod(String categoryOfStringCase, List<StringCaseReturnIndex> stringCaseReturnIndices) {
        StringCaseReturnIndex stringCaseReturnIndex;
        int i;
        this.mv = this.cw.visitMethod(1, categoryOfStringCase + "Index", "(Ljava/lang/String;)I", null, null);
        this.mv.visitCode();
        Label firstLabel = new Label();
        this.mv.visitLabel(firstLabel);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(58, 2);
        this.mv.visitMethodInsn(182, "java/lang/String", "hashCode", "()I", false);
        Label defaultCaseLabel = new Label();
        if (stringCaseReturnIndices.isEmpty()) {
            this.mv.visitInsn(87);
            this.mv.visitLabel(defaultCaseLabel);
            this.visitIndexMethodLastPart(categoryOfStringCase, firstLabel);
            return;
        }
        Collections.sort(stringCaseReturnIndices, (x$0, x$1) -> StringCaseReturnIndex.compareHashCode((StringCaseReturnIndex)x$0, (StringCaseReturnIndex)x$1));
        int[] stringHashCodes = new int[stringCaseReturnIndices.size()];
        Label[] caseLabels = new Label[stringCaseReturnIndices.size()];
        for (i = 0; i < stringCaseReturnIndices.size(); ++i) {
            stringHashCodes[i] = stringCaseReturnIndices.get((int)i).hashCode;
            caseLabels[i] = new Label();
        }
        this.mv.visitLookupSwitchInsn(defaultCaseLabel, stringHashCodes, caseLabels);
        for (i = 0; i < stringCaseReturnIndices.size(); ++i) {
            stringCaseReturnIndex = stringCaseReturnIndices.get(i);
            this.mv.visitLabel(caseLabels[i]);
            if (i > 0) {
                this.mv.visitFrame(3, 0, null, 0, null);
            } else {
                this.mv.visitFrame(1, 1, new Object[]{"java/lang/String"}, 0, null);
            }
            this.mv.visitVarInsn(25, 2);
            this.mv.visitLdcInsn(stringCaseReturnIndex.name);
            this.mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
            this.mv.visitJumpInsn(154, stringCaseReturnIndex.returnIndexLabel);
            this.mv.visitJumpInsn(167, defaultCaseLabel);
        }
        Collections.sort(stringCaseReturnIndices, (x$0, x$1) -> StringCaseReturnIndex.compareIndex((StringCaseReturnIndex)x$0, (StringCaseReturnIndex)x$1));
        for (i = 0; i < stringCaseReturnIndices.size(); ++i) {
            stringCaseReturnIndex = stringCaseReturnIndices.get(i);
            this.mv.visitLabel(stringCaseReturnIndex.returnIndexLabel);
            this.mv.visitFrame(3, 0, null, 0, null);
            AsmUtils.visitZeroOperandInt(this.mv, stringCaseReturnIndex.index);
            this.mv.visitInsn(172);
        }
        this.mv.visitLabel(defaultCaseLabel);
        this.mv.visitFrame(3, 0, null, 0, null);
        this.visitIndexMethodLastPart(categoryOfStringCase, firstLabel);
    }

    private void visitIndexMethodLastPart(String categoryOfStringCase, Label firstLabel) {
        this.mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(187, "java/lang/StringBuilder");
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn("No " + categoryOfStringCase + " with name: ");
        this.mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        this.mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitInsn(191);
        Label lastLabel = new Label();
        this.mv.visitLabel(lastLabel);
        this.mv.visitLocalVariable("this", this.classAccessTypeDescriptor, null, firstLabel, lastLabel, 0);
        this.mv.visitLocalVariable("name", "Ljava/lang/String;", null, firstLabel, lastLabel, 1);
        this.mv.visitMaxs(5, 3);
        this.mv.visitEnd();
    }

    private void visitMethodAccessBridge(int parameterCount) {
        this.mv = this.cw.visitMethod(4161, "call", this.getMethodAccessMethodDescriptor(parameterCount, "Ljava/lang/Object;"), null, null);
        this.mv.visitCode();
        this.mv.visitLabel(new Label());
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitTypeInsn(192, this.internalName);
        this.mv.visitVarInsn(21, 2);
        for (int i = 0; i < parameterCount; ++i) {
            this.mv.visitVarInsn(25, 3 + i);
        }
        this.mv.visitMethodInsn(182, this.classAccessInternalName, "call", this.getMethodAccessMethodDescriptor(parameterCount), false);
        this.mv.visitInsn(176);
        this.mv.visitMaxs(3 + parameterCount, 3 + parameterCount);
        this.mv.visitEnd();
    }

    private void visitMethodAccessInvokeBridge() {
        this.mv = this.cw.visitMethod(4289, "invoke", "(Ljava/lang/Object;I[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        this.mv.visitCode();
        this.mv.visitLabel(new Label());
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitTypeInsn(192, this.internalName);
        this.mv.visitVarInsn(21, 2);
        this.mv.visitVarInsn(25, 3);
        this.mv.visitMethodInsn(182, this.classAccessInternalName, "invoke", "(" + this.classTypeDescriptor + "I[Ljava/lang/Object;)Ljava/lang/Object;", false);
        this.mv.visitInsn(176);
        this.mv.visitMaxs(4, 4);
        this.mv.visitEnd();
    }

    private void visitMethodAccessInvokeMethod() {
        this.mv = this.cw.visitMethod(129, "invoke", "(" + this.classTypeDescriptor + "I[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        this.mv.visitCode();
        Label firstLabel = new Label();
        this.mv.visitLabel(firstLabel);
        this.mv.visitVarInsn(21, 2);
        Label defaultCaseLabel = new Label();
        if (this.methodInfoList == null || this.methodInfoList.isEmpty()) {
            this.mv.visitInsn(87);
            this.mv.visitLabel(defaultCaseLabel);
            this.visitMethodAccessInvokeMethodLastPart(firstLabel);
            return;
        }
        Label[] labels = ClassAccessFactory.getTableSwitchLabelsForAccess(defaultCaseLabel, this.methodInfoList);
        this.mv.visitTableSwitchInsn(this.methodInfoList.get((int)0).memberIndex, this.methodInfoList.get((int)(this.methodInfoList.size() - 1)).memberIndex, defaultCaseLabel, labels);
        for (int i = 0; i < this.methodInfoList.size(); ++i) {
            MethodInfo methodInfo = this.methodInfoList.get(i);
            this.mv.visitLabel(labels[i]);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitVarInsn(25, 1);
            List parameters = methodInfo.parameters;
            for (int j = 0; j < parameters.size(); ++j) {
                ParameterInfo parameter = (ParameterInfo)parameters.get(j);
                this.mv.visitVarInsn(25, 3);
                AsmUtils.visitZeroOperandInt(this.mv, j);
                this.mv.visitInsn(50);
                this.checkCast(parameter);
            }
            this.mv.visitMethodInsn(methodInfo.invokeOpcode, this.internalName, methodInfo.name, methodInfo.descriptor, true);
            if (methodInfo.method.getReturnType() == Void.TYPE) {
                this.mv.visitLabel(new Label());
                this.mv.visitInsn(1);
            }
            this.mv.visitInsn(176);
        }
        this.mv.visitLabel(defaultCaseLabel);
        this.mv.visitFrame(3, 0, null, 0, null);
        this.visitMethodAccessInvokeMethodLastPart(firstLabel);
    }

    private void visitMethodAccessInvokeMethodLastPart(Label firstLabel) {
        this.mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(187, "java/lang/StringBuilder");
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn("No method with index: ");
        this.mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitVarInsn(21, 2);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        this.mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitInsn(191);
        Label lastLabel = new Label();
        this.mv.visitLabel(lastLabel);
        this.mv.visitLocalVariable("this", this.classAccessTypeDescriptor, null, firstLabel, lastLabel, 0);
        this.mv.visitLocalVariable("obj", this.classTypeDescriptor, null, firstLabel, lastLabel, 1);
        this.mv.visitLocalVariable("methodIndex", "I", null, firstLabel, lastLabel, 2);
        this.mv.visitLocalVariable("args", "[Ljava/lang/Object;", null, firstLabel, lastLabel, 3);
        this.mv.visitMaxs(5, 4);
        this.mv.visitEnd();
    }

    private void visitMethodAccessLastPart(Label firstLabel, int parameterCount) {
        this.mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(187, "java/lang/StringBuilder");
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn("No method with index ");
        this.mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitLabel(new Label());
        this.mv.visitVarInsn(21, 2);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false);
        this.mv.visitLdcInsn(" with " + parameterCount + " parameter(s)");
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        this.mv.visitLabel(new Label());
        this.mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitInsn(191);
        Label lastLabel = new Label();
        this.mv.visitLabel(lastLabel);
        this.mv.visitLocalVariable("this", this.classAccessTypeDescriptor, null, firstLabel, lastLabel, 0);
        this.mv.visitLocalVariable("obj", this.classTypeDescriptor, null, firstLabel, lastLabel, 1);
        this.mv.visitLocalVariable("methodIndex", "I", null, firstLabel, lastLabel, 2);
        for (int i = 0; i < parameterCount; ++i) {
            this.mv.visitLocalVariable("arg" + i, "Ljava/lang/Object;", null, firstLabel, lastLabel, 3 + i);
        }
        this.mv.visitMaxs(5, 3 + parameterCount);
        this.mv.visitEnd();
    }

    private void visitMethodAccessMethod(int parameterCount) {
        Label[] labels;
        List<MethodInfo> methodsWithParamCount = this.paramCountMethodsMap.get(parameterCount);
        this.mv = this.cw.visitMethod(1, "call", this.getMethodAccessMethodDescriptor(parameterCount), null, null);
        this.mv.visitCode();
        Label firstLabel = new Label();
        this.mv.visitLabel(firstLabel);
        this.mv.visitVarInsn(21, 2);
        Label defaultCaseLabel = new Label();
        if (methodsWithParamCount == null || methodsWithParamCount.isEmpty()) {
            this.mv.visitInsn(87);
            this.mv.visitLabel(defaultCaseLabel);
            this.visitMethodAccessLastPart(firstLabel, parameterCount);
            return;
        }
        boolean useTableSwitch = ClassAccessFactory.useTableSwitch(methodsWithParamCount);
        Label[] labelArray = labels = useTableSwitch ? ClassAccessFactory.getTableSwitchLabelsForAccess(defaultCaseLabel, methodsWithParamCount) : ClassAccessFactory.newLabelArray(methodsWithParamCount.size());
        if (useTableSwitch) {
            this.mv.visitTableSwitchInsn(methodsWithParamCount.get((int)0).memberIndex, methodsWithParamCount.get((int)(methodsWithParamCount.size() - 1)).memberIndex, defaultCaseLabel, labels);
        } else {
            this.mv.visitLookupSwitchInsn(defaultCaseLabel, methodsWithParamCount.stream().mapToInt(f -> f.memberIndex).toArray(), labels);
        }
        for (int i = 0; i < methodsWithParamCount.size(); ++i) {
            MethodInfo methodInfo = methodsWithParamCount.get(i);
            this.mv.visitLabel(labels[i]);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitVarInsn(25, 1);
            List parameters = methodInfo.parameters;
            for (int j = 0; j < parameters.size(); ++j) {
                ParameterInfo parameter = (ParameterInfo)parameters.get(j);
                this.mv.visitVarInsn(25, 3 + j);
                this.checkCast(parameter);
            }
            this.mv.visitMethodInsn(methodInfo.invokeOpcode, this.internalName, methodInfo.name, methodInfo.descriptor, true);
            if (methodInfo.method.getReturnType() == Void.TYPE) {
                this.mv.visitLabel(new Label());
                this.mv.visitInsn(1);
            }
            this.mv.visitInsn(176);
        }
        this.mv.visitLabel(defaultCaseLabel);
        this.mv.visitFrame(3, 0, null, 0, null);
        this.visitMethodAccessLastPart(firstLabel, parameterCount);
    }

    private void visitMethodAccessMethods() {
        this.visitMethodAccessInvokeMethod();
        this.visitMethodAccessInvokeBridge();
        for (int i = 0; i <= 22; ++i) {
            this.visitMethodAccessMethod(i);
            this.visitMethodAccessBridge(i);
        }
    }

    private void visitMethodIndexMethod() {
        int i;
        this.mv = this.cw.visitMethod(129, "methodIndex", "(Ljava/lang/String;[Ljava/lang/Class;)I", "(Ljava/lang/String;[Ljava/lang/Class<*>;)I", null);
        this.mv.visitCode();
        Label firstLabel = new Label();
        this.mv.visitLabel(firstLabel);
        List<MethodNameReturnIndex> methodIndices = this.getMethodIndexSwitchCases();
        if (methodIndices.isEmpty()) {
            this.visitMethodIndexMethodLastPart(firstLabel, methodIndices);
            return;
        }
        this.mv.visitVarInsn(25, 1);
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(58, 3);
        this.mv.visitMethodInsn(182, "java/lang/String", "hashCode", "()I", false);
        Label defaultCaseLabel = new Label();
        Collections.sort(methodIndices, (x$0, x$1) -> StringCaseReturnIndex.compareHashCode((StringCaseReturnIndex)x$0, (StringCaseReturnIndex)x$1));
        int[] methodNameHashCodes = new int[methodIndices.size()];
        Label[] caseLabels = new Label[methodIndices.size()];
        for (i = 0; i < methodIndices.size(); ++i) {
            methodNameHashCodes[i] = methodIndices.get((int)i).hashCode;
            caseLabels[i] = new Label();
        }
        this.mv.visitLookupSwitchInsn(defaultCaseLabel, methodNameHashCodes, caseLabels);
        for (i = 0; i < methodIndices.size(); ++i) {
            MethodNameReturnIndex methodIndex = methodIndices.get(i);
            this.mv.visitLabel(caseLabels[i]);
            if (i > 0) {
                this.mv.visitFrame(3, 0, null, 0, null);
            } else {
                this.mv.visitFrame(1, 1, new Object[]{"java/lang/String"}, 0, null);
            }
            this.mv.visitVarInsn(25, 3);
            this.mv.visitLdcInsn(methodIndex.name);
            this.mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", false);
            this.mv.visitJumpInsn(154, methodIndex.returnIndexLabel);
            this.mv.visitJumpInsn(167, defaultCaseLabel);
        }
        Collections.sort(methodIndices, (x$0, x$1) -> StringCaseReturnIndex.compareIndex((StringCaseReturnIndex)x$0, (StringCaseReturnIndex)x$1));
        for (i = 0; i < methodIndices.size(); ++i) {
            this.visitMethodIndexReturnStatements(methodIndices.get(i), defaultCaseLabel);
        }
        this.mv.visitLabel(defaultCaseLabel);
        this.mv.visitFrame(2, 1, null, 0, null);
        this.visitMethodIndexMethodLastPart(firstLabel, methodIndices);
    }

    private void visitMethodIndexMethodLastPart(Label firstLabel, List<MethodNameReturnIndex> methodIndices) {
        this.mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        this.mv.visitInsn(89);
        this.mv.visitTypeInsn(187, "java/lang/StringBuilder");
        this.mv.visitInsn(89);
        this.mv.visitLdcInsn("No method called ");
        this.mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        this.mv.visitLabel(new Label());
        this.mv.visitLdcInsn(" with parameters ");
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        this.mv.visitVarInsn(25, 2);
        this.mv.visitMethodInsn(184, "java/util/Arrays", "stream", "([Ljava/lang/Object;)Ljava/util/stream/Stream;", false);
        this.mv.visitLabel(new Label());
        this.mv.visitInvokeDynamicInsn("apply", "()Ljava/util/function/Function;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), Type.getType("(Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(5, "java/lang/Class", "getName", "()Ljava/lang/String;", false), Type.getType("(Ljava/lang/Class;)Ljava/lang/String;"));
        this.mv.visitMethodInsn(185, "java/util/stream/Stream", "map", "(Ljava/util/function/Function;)Ljava/util/stream/Stream;", true);
        this.mv.visitLabel(new Label());
        this.mv.visitMethodInsn(184, "java/util/stream/Collectors", "toList", "()Ljava/util/stream/Collector;", false);
        this.mv.visitMethodInsn(185, "java/util/stream/Stream", "collect", "(Ljava/util/stream/Collector;)Ljava/lang/Object;", true);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;", false);
        this.mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        this.mv.visitLabel(new Label());
        this.mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V", false);
        this.mv.visitInsn(191);
        Label lastLabel = new Label();
        this.mv.visitLabel(lastLabel);
        this.mv.visitLocalVariable("this", this.classAccessTypeDescriptor, null, firstLabel, lastLabel, 0);
        this.mv.visitLocalVariable("name", "Ljava/lang/String;", null, firstLabel, lastLabel, 1);
        this.mv.visitLocalVariable("parameterTypes", "[Ljava/lang/Class;", null, firstLabel, lastLabel, 2);
        this.mv.visitMaxs(5, methodIndices.isEmpty() ? 3 : 4);
        this.mv.visitEnd();
    }

    private void visitMethodIndexReturnStatements(MethodNameReturnIndex methodIndex, Label defaultCaseLabel) {
        Label jumpLabel = methodIndex.returnIndexLabel;
        List methods = methodIndex.methods;
        for (int i = 0; i < methods.size(); ++i) {
            MethodInfo methodInfo = (MethodInfo)methods.get(i);
            Class<?>[] parameterTypes = methodInfo.method.getParameterTypes();
            this.mv.visitLabel(jumpLabel);
            this.mv.visitFrame(3, 0, null, 0, null);
            this.mv.visitVarInsn(25, 2);
            AsmUtils.visitZeroOperandInt(this.mv, parameterTypes.length);
            this.mv.visitTypeInsn(189, "java/lang/Class");
            for (int j = 0; j < parameterTypes.length; ++j) {
                this.mv.visitInsn(89);
                AsmUtils.visitZeroOperandInt(this.mv, j);
                Class<?> parameterType = parameterTypes[j];
                if (parameterType.isPrimitive()) {
                    this.mv.visitFieldInsn(178, Type.getInternalName(ClassUtils.primitiveToWrapper(parameterType)), "TYPE", "Ljava/lang/Class;");
                } else {
                    this.mv.visitLdcInsn(Type.getType(parameterType));
                }
                this.mv.visitInsn(83);
            }
            this.mv.visitMethodInsn(184, "java/util/Arrays", "equals", "([Ljava/lang/Object;[Ljava/lang/Object;)Z", false);
            jumpLabel = i + 1 >= methods.size() ? defaultCaseLabel : new Label();
            this.mv.visitJumpInsn(153, jumpLabel);
            this.mv.visitLabel(new Label());
            AsmUtils.visitZeroOperandInt(this.mv, methodInfo.memberIndex);
            this.mv.visitInsn(172);
        }
    }

    private void visitPropertyAccessMethods() {
        List<AccessInfo> propertyAccessInfoList = Collections.unmodifiableList(Arrays.asList(AccessInfo.forPrimitive(MEMBER_TYPE_PROPERTY, Type.BOOLEAN_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_PROPERTY, Type.BYTE_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_PROPERTY, Type.CHAR_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_PROPERTY, Type.DOUBLE_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_PROPERTY, Type.FLOAT_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_PROPERTY, Type.INT_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_PROPERTY, Type.LONG_TYPE), AccessInfo.forPrimitive(MEMBER_TYPE_PROPERTY, Type.SHORT_TYPE), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_PROPERTY, Boolean.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_PROPERTY, Byte.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_PROPERTY, Character.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_PROPERTY, Double.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_PROPERTY, Float.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_PROPERTY, Integer.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_PROPERTY, Long.class), AccessInfo.forPrimitiveWrapper(MEMBER_TYPE_PROPERTY, Short.class), AccessInfo.forReferenceType(MEMBER_TYPE_PROPERTY, BigDecimal.class), AccessInfo.forReferenceType(MEMBER_TYPE_PROPERTY, Date.class), AccessInfo.forReferenceType(MEMBER_TYPE_PROPERTY, LocalDate.class), AccessInfo.forReferenceType(MEMBER_TYPE_PROPERTY, LocalDateTime.class), AccessInfo.forReferenceType(MEMBER_TYPE_PROPERTY, String.class)));
        for (int i = 0; i < propertyAccessInfoList.size(); ++i) {
            AccessInfo propertyAccessInfo = propertyAccessInfoList.get(i);
            this.visitAccessGetter(this.typeToAccessorsMap.get(propertyAccessInfo.className), propertyAccessInfo);
            this.visitAccessGetterBridge(propertyAccessInfo);
            this.visitAccessSetter(this.typeToMutatorsMap.get(propertyAccessInfo.className), propertyAccessInfo);
            this.visitAccessSetterBridge(propertyAccessInfo);
        }
        this.visitGeneralAccessGetter("getProperty", MEMBER_TYPE_PROPERTY, this.accessorInfoList);
        this.visitAccessGetterBridge("getProperty", "Ljava/lang/Object;", 176);
        this.visitGeneralAccessSetter("setProperty", MEMBER_TYPE_PROPERTY, this.mutatorInfoList);
        this.visitAccessSetterBridge("setProperty", 25, "Ljava/lang/Object;");
    }

    private static class StringCaseReturnIndex {
        protected final int hashCode;
        protected final int index;
        protected final String name;
        protected final Label returnIndexLabel = new Label();

        private static int compareIndex(StringCaseReturnIndex a, StringCaseReturnIndex b) {
            return Integer.compare(a.index, b.index);
        }

        private static int compareHashCode(StringCaseReturnIndex a, StringCaseReturnIndex b) {
            return Integer.compare(a.hashCode, b.hashCode);
        }

        protected StringCaseReturnIndex(String name, int index) {
            this.hashCode = name.hashCode();
            this.index = index;
            this.name = name;
        }
    }

    private static class PropertyInfo
    extends AssignableInfo {
        private final String readMethodName;
        private final String writeMethodName;

        private PropertyInfo(PropertyDescriptor propertyDescriptor, int propertyIndex) {
            super(propertyDescriptor.getName(), propertyIndex, propertyDescriptor.getPropertyType());
            this.readMethodName = Optional.ofNullable(propertyDescriptor.getReadMethod()).map(prop -> prop.getName()).orElse(null);
            this.writeMethodName = Optional.ofNullable(propertyDescriptor.getWriteMethod()).map(prop -> prop.getName()).orElse(null);
        }
    }

    private static class ParameterInfo
    implements Castable {
        private final String descriptor;
        private final String internalName;
        private final Class<?> type;

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public String getInternalName() {
            return this.internalName;
        }

        @Override
        public Class getType() {
            return this.type;
        }

        private ParameterInfo(Class<?> type) {
            this.descriptor = Type.getDescriptor(type);
            this.internalName = Type.getInternalName(type);
            this.type = type;
        }
    }

    private static class MethodNameReturnIndex
    extends StringCaseReturnIndex {
        private final List<MethodInfo> methods;

        private MethodNameReturnIndex(List<MethodInfo> methods) {
            super(methods.get((int)0).name, methods.get((int)0).memberIndex);
            this.methods = methods;
        }
    }

    private static class MethodInfo
    extends MemberInfo {
        private final int invokeOpcode;
        private final Method method;
        private final int parameterCount;
        private final List<ParameterInfo> parameters;

        private MethodInfo(Method method, int index) {
            super(method.getName(), index, Type.getMethodDescriptor(method));
            this.invokeOpcode = method.getDeclaringClass().isInterface() ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : 182);
            this.method = method;
            this.parameterCount = method.getParameterCount();
            this.parameters = Collections.unmodifiableList(Arrays.stream(method.getParameterTypes()).map(x$0 -> new ParameterInfo((Class)x$0)).collect(Collectors.toList()));
        }
    }

    private static abstract class MemberInfo {
        protected final String descriptor;
        protected final int memberIndex;
        protected final String name;

        private MemberInfo(String name, int memberIndex, String descriptor) {
            this.descriptor = descriptor;
            this.name = name;
            this.memberIndex = memberIndex;
        }
    }

    private static class FieldInfo
    extends AssignableInfo {
        private final int getFieldOpcode;
        private final int setFieldOpcode;

        private FieldInfo(Field field, int fieldIndex) {
            super(field.getName(), fieldIndex, field.getType());
            this.getFieldOpcode = Modifier.isStatic(field.getModifiers()) ? 178 : 180;
            this.setFieldOpcode = Modifier.isStatic(field.getModifiers()) ? 179 : 181;
        }
    }

    private static interface Castable {
        public String getDescriptor();

        public String getInternalName();

        public Class getType();
    }

    private static abstract class AssignableInfo
    extends MemberInfo
    implements Castable {
        protected final String internalName;
        protected final Class<?> type;

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public String getInternalName() {
            return this.internalName;
        }

        @Override
        public Class getType() {
            return this.type;
        }

        private AssignableInfo(String name, int memberIndex, Class<?> type) {
            super(name, memberIndex, Type.getDescriptor(type));
            this.internalName = Type.getInternalName(type);
            this.type = type;
        }
    }

    private static class AccessInfo {
        private final String className;
        private final String descriptor;
        private final String getMethodName;
        private final int loadOpcode;
        private final String memberType;
        private final int returnOpcode;
        private final String setMethodName;

        private static AccessInfo forPrimitive(String memberType, Type type) {
            String camelCaseClassName = WordUtils.capitalize(type.getClassName());
            String capitalizedMemberType = WordUtils.capitalize(memberType);
            return new AccessInfo(memberType, "get" + camelCaseClassName + capitalizedMemberType, "set" + camelCaseClassName + capitalizedMemberType, type.getClassName(), type.getDescriptor(), type.getOpcode(21), type.getOpcode(172));
        }

        private static AccessInfo forPrimitiveWrapper(String memberType, Class<?> clazz) {
            Class<?> primitiveClass = ClassUtils.wrapperToPrimitive(clazz);
            String camelCaseClassName = WordUtils.capitalize(primitiveClass.getName());
            String capitalizedMemberType = WordUtils.capitalize(memberType);
            return new AccessInfo(memberType, "getBoxed" + camelCaseClassName + capitalizedMemberType, "setBoxed" + camelCaseClassName + capitalizedMemberType, clazz.getName(), Type.getDescriptor(clazz), 25, 176);
        }

        private static AccessInfo forReferenceType(String memberType, Class<?> clazz) {
            String capitalizedMemberType = WordUtils.capitalize(memberType);
            return new AccessInfo(memberType, "get" + clazz.getSimpleName() + capitalizedMemberType, "set" + clazz.getSimpleName() + capitalizedMemberType, clazz.getName(), Type.getDescriptor(clazz), 25, 176);
        }

        private AccessInfo(String memberType, String getMethodName, String setMethodName, String className, String descriptor, int loadOpcode, int returnOpcode) {
            this.className = className;
            this.descriptor = descriptor;
            this.getMethodName = getMethodName;
            this.loadOpcode = loadOpcode;
            this.memberType = memberType;
            this.returnOpcode = returnOpcode;
            this.setMethodName = setMethodName;
        }
    }
}

