/*
 * Decompiled with CFR 0.152.
 */
package com.github.javalbert.bytecode.utils;

import com.github.javalbert.asm.ClassWriter;
import com.github.javalbert.asm.Label;
import com.github.javalbert.asm.MethodVisitor;
import java.util.ArrayList;

public final class AsmUtils {
    public static Label[] getTableSwitchLabels(Label defaultCaseLabel, int[] cases) {
        int lo;
        ArrayList<Label> labels = new ArrayList<Label>();
        int currentCase = 0;
        int caseValue = cases[0];
        int hi = cases[cases.length - 1];
        for (int i = lo = cases[0]; i <= hi; ++i) {
            int currentCaseValue = cases[currentCase];
            if (caseValue < currentCaseValue) {
                labels.add(defaultCaseLabel);
                ++caseValue;
                continue;
            }
            labels.add(new Label());
            caseValue = currentCaseValue + 1;
            ++currentCase;
        }
        return (Label[])labels.stream().toArray(Label[]::new);
    }

    public static boolean useTableSwitch(int[] cases) {
        int hi = cases[cases.length - 1];
        int lo = cases[0];
        int nlabels = cases.length;
        long table_space_cost = 4L + ((long)hi - (long)lo + 1L);
        long table_time_cost = 3L;
        long lookup_space_cost = 3L + 2L * (long)nlabels;
        long lookup_time_cost = nlabels;
        return nlabels > 0 && table_space_cost + 3L * table_time_cost <= lookup_space_cost + 3L * lookup_time_cost;
    }

    public static void visitDefaultConstructor(ClassWriter cw, String classTypeDescriptor) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", classTypeDescriptor, null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public static void visitZeroOperandInt(MethodVisitor mv, int i) {
        if (i > 5) {
            mv.visitIntInsn(16, i);
        } else {
            int opcode = 0;
            switch (i) {
                case 0: {
                    opcode = 3;
                    break;
                }
                case 1: {
                    opcode = 4;
                    break;
                }
                case 2: {
                    opcode = 5;
                    break;
                }
                case 3: {
                    opcode = 6;
                    break;
                }
                case 4: {
                    opcode = 7;
                    break;
                }
                case 5: {
                    opcode = 8;
                }
            }
            mv.visitInsn(opcode);
        }
    }

    private AsmUtils() {
    }
}

