/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.parsers;

import com.github.jasync.sql.db.exceptions.UnsupportedAuthenticationMethodException;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ServerMessage;
import com.github.jasync.sql.db.postgresql.parsers.MessageParser;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/jasync/sql/db/postgresql/parsers/AuthenticationStartupParser;", "Lcom/github/jasync/sql/db/postgresql/parsers/MessageParser;", "()V", "AuthenticationCleartextPassword", "", "AuthenticationGSS", "AuthenticationGSSContinue", "AuthenticationKerberosV5", "AuthenticationMD5Password", "AuthenticationOk", "AuthenticationSCMCredential", "AuthenticationSSPI", "parseMessage", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ServerMessage;", "buffer", "Lio/netty/buffer/ByteBuf;", "jasync-postgresql"})
public final class AuthenticationStartupParser
implements MessageParser {
    public static final int AuthenticationOk = 0;
    public static final int AuthenticationKerberosV5 = 2;
    public static final int AuthenticationCleartextPassword = 3;
    public static final int AuthenticationMD5Password = 5;
    public static final int AuthenticationSCMCredential = 6;
    public static final int AuthenticationGSS = 7;
    public static final int AuthenticationGSSContinue = 8;
    public static final int AuthenticationSSPI = 9;
    public static final AuthenticationStartupParser INSTANCE;

    @Override
    @NotNull
    public ServerMessage parseMessage(@NotNull ByteBuf buffer) {
        ServerMessage serverMessage;
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        int authenticationType = buffer.readInt();
        switch (authenticationType) {
            case 0: {
                serverMessage = AuthenticationOkMessage.INSTANCE;
                break;
            }
            case 3: {
                serverMessage = AuthenticationChallengeCleartextMessage.INSTANCE;
                break;
            }
            case 5: {
                byte[] bytes = new byte[buffer.readableBytes()];
                buffer.readBytes(bytes);
                serverMessage = new AuthenticationChallengeMD5(bytes);
                break;
            }
            default: {
                throw (Throwable)new UnsupportedAuthenticationMethodException(authenticationType);
            }
        }
        return serverMessage;
    }

    private AuthenticationStartupParser() {
    }

    static {
        AuthenticationStartupParser authenticationStartupParser;
        INSTANCE = authenticationStartupParser = new AuthenticationStartupParser();
    }
}

