/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.encoder;

import com.github.jasync.sql.db.exceptions.UnsupportedAuthenticationMethodException;
import com.github.jasync.sql.db.mysql.encoder.MessageEncoder;
import com.github.jasync.sql.db.mysql.encoder.auth.AuthenticationMethod;
import com.github.jasync.sql.db.mysql.message.client.AuthenticationSwitchResponse;
import com.github.jasync.sql.db.mysql.message.client.ClientMessage;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/AuthenticationSwitchResponseEncoder;", "Lcom/github/jasync/sql/db/mysql/encoder/MessageEncoder;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/mysql/message/client/ClientMessage;", "jasync-mysql"})
public final class AuthenticationSwitchResponseEncoder
implements MessageEncoder {
    @NotNull
    private final Charset charset;

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        AuthenticationSwitchResponse authenticationSwitchResponse = (AuthenticationSwitchResponse)message;
        String method = authenticationSwitchResponse.getRequest().getMethod();
        Map<String, AuthenticationMethod> map = AuthenticationMethod.Companion.getAvailables();
        boolean bl = false;
        AuthenticationMethod authenticationMethod = map.get(method);
        if (authenticationMethod == null) {
            boolean bl2 = false;
            throw (Throwable)new UnsupportedAuthenticationMethodException(method);
        }
        AuthenticationMethod authenticator = authenticationMethod;
        ByteBuf buffer = ByteBufferUtils.packetBuffer();
        String string = authenticationSwitchResponse.getRequest().getSeed();
        Charset charset = this.charset;
        String string2 = authenticationSwitchResponse.getPassword();
        Charset charset2 = this.charset;
        AuthenticationMethod authenticationMethod2 = authenticator;
        boolean bl3 = false;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] bytes = authenticationMethod2.generateAuthentication(charset2, string2, byArray2);
        buffer.writeBytes(bytes);
        ByteBuf byteBuf = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
        return byteBuf;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public AuthenticationSwitchResponseEncoder(@NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        this.charset = charset;
    }
}

