/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql;

import com.github.jasync.sql.db.ConcreteConnectionBase;
import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.ResultSet;
import com.github.jasync.sql.db.ResultSetKt;
import com.github.jasync.sql.db.exceptions.ConnectionStillRunningQueryException;
import com.github.jasync.sql.db.exceptions.DatabaseException;
import com.github.jasync.sql.db.exceptions.InsufficientParametersException;
import com.github.jasync.sql.db.interceptor.PreparedStatementParams;
import com.github.jasync.sql.db.mysql.MySQLConnection$close$;
import com.github.jasync.sql.db.mysql.MySQLConnection$unregistered$;
import com.github.jasync.sql.db.mysql.MySQLConnectionKt;
import com.github.jasync.sql.db.mysql.MySQLQueryResult;
import com.github.jasync.sql.db.mysql.codec.MySQLConnectionHandler;
import com.github.jasync.sql.db.mysql.codec.MySQLHandlerDelegate;
import com.github.jasync.sql.db.mysql.exceptions.MySQLException;
import com.github.jasync.sql.db.mysql.message.client.AuthenticationSwitchResponse;
import com.github.jasync.sql.db.mysql.message.client.HandshakeResponseMessage;
import com.github.jasync.sql.db.mysql.message.server.AuthenticationSwitchRequest;
import com.github.jasync.sql.db.mysql.message.server.EOFMessage;
import com.github.jasync.sql.db.mysql.message.server.ErrorMessage;
import com.github.jasync.sql.db.mysql.message.server.HandshakeMessage;
import com.github.jasync.sql.db.mysql.message.server.OkMessage;
import com.github.jasync.sql.db.mysql.util.CharsetMapper;
import com.github.jasync.sql.db.pool.TimeoutScheduler;
import com.github.jasync.sql.db.pool.TimeoutSchedulerImpl;
import com.github.jasync.sql.db.util.ChannelFutureTransformerKt;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import com.github.jasync.sql.db.util.Failure;
import com.github.jasync.sql.db.util.FutureUtilsKt;
import com.github.jasync.sql.db.util.Success;
import com.github.jasync.sql.db.util.Try;
import com.github.jasync.sql.db.util.VersionKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 Y2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002YZB\u0019\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0012H\u0002J\u0014\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u00140 H\u0002J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014H\u0016J\u0010\u0010\f\u001a\u00020+2\u0006\u00100\u001a\u000201H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\u0010\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u001bH\u0016J\u0010\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020\u001bH\u0002J\b\u00107\u001a\u00020\u000bH\u0016J\u0006\u00108\u001a\u00020\u000bJ\b\u00109\u001a\u00020\u000bH\u0016J\b\u0010:\u001a\u00020\u000bH\u0016J\b\u0010;\u001a\u00020\u000bH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010<\u001a\u00020+2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020+2\u0006\u0010=\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020+2\u0006\u0010=\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020+2\u0006\u0010=\u001a\u00020DH\u0016J\u0018\u0010E\u001a\u00020+2\u0006\u0010F\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010G\u001a\u00020+H\u0002J\u0014\u0010H\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u00140 H\u0002J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010,\u001a\u00020\u0012H\u0016J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020!0\u00142\u0006\u0010K\u001a\u00020LH\u0016J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020!0\u00142\u0006\u0010,\u001a\u00020\u0012H\u0016J\u0010\u0010N\u001a\u00020+2\u0006\u00106\u001a\u00020\u001bH\u0002J\u0016\u0010O\u001a\u00020+2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020!0\u0014H\u0002J\u0010\u0010Q\u001a\u00020+2\u0006\u0010R\u001a\u00020!H\u0002J\u0010\u0010S\u001a\u00020+2\u0006\u0010=\u001a\u00020TH\u0016J\b\u0010U\u001a\u00020\u0012H\u0016J\b\u0010V\u001a\u00020+H\u0016J\b\u0010W\u001a\u00020+H\u0002J\u000e\u0010X\u001a\n\u0018\u00010&j\u0004\u0018\u0001`'R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u00140 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n\u0018\u00010&j\u0004\u0018\u0001`'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/github/jasync/sql/db/mysql/MySQLConnection;", "Lcom/github/jasync/sql/db/ConcreteConnectionBase;", "Lcom/github/jasync/sql/db/mysql/codec/MySQLHandlerDelegate;", "Lcom/github/jasync/sql/db/Connection;", "Lcom/github/jasync/sql/db/pool/TimeoutScheduler;", "configuration", "Lcom/github/jasync/sql/db/Configuration;", "charsetMapper", "Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;", "(Lcom/github/jasync/sql/db/Configuration;Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;)V", "channelClosed", "", "connected", "connectionCount", "", "connectionHandler", "Lcom/github/jasync/sql/db/mysql/codec/MySQLConnectionHandler;", "connectionId", "", "connectionPromise", "Ljava/util/concurrent/CompletableFuture;", "disconnectionPromise", "id", "getId", "()Ljava/lang/String;", "isStoredProcedureCall", "lastException", "", "lastResultSet", "Lcom/github/jasync/sql/db/ResultSet;", "queryPromiseReference", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/Optional;", "Lcom/github/jasync/sql/db/QueryResult;", "reportErrorAfterChannelClosed", "serverStatus", "", "serverVersion", "Lkotlin/KotlinVersion;", "Lcom/github/jasync/sql/db/util/Version;", "timeoutSchedulerImpl", "Lcom/github/jasync/sql/db/pool/TimeoutSchedulerImpl;", "checkStoredProcedureCall", "", "query", "clearQueryPromise", "close", "connect", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "disconnect", "exceptionCaught", "exception", "failQueryPromise", "t", "hasRecentError", "isAutoCommit", "isConnected", "isQuerying", "isTimeout", "onEOF", "message", "Lcom/github/jasync/sql/db/mysql/message/server/EOFMessage;", "onError", "Lcom/github/jasync/sql/db/mysql/message/server/ErrorMessage;", "onHandshake", "Lcom/github/jasync/sql/db/mysql/message/server/HandshakeMessage;", "onOk", "Lcom/github/jasync/sql/db/mysql/message/server/OkMessage;", "onResultSet", "resultSet", "onTimeout", "queryPromise", "releasePreparedStatement", "sendPreparedStatementDirect", "params", "Lcom/github/jasync/sql/db/interceptor/PreparedStatementParams;", "sendQueryDirect", "setException", "setQueryPromise", "promise", "succeedQueryPromise", "queryResult", "switchAuthentication", "Lcom/github/jasync/sql/db/mysql/message/server/AuthenticationSwitchRequest;", "toString", "unregistered", "validateIsReadyForQuery", "version", "Companion", "StatusFlags", "jasync-mysql"})
public final class MySQLConnection
extends ConcreteConnectionBase
implements MySQLHandlerDelegate,
Connection,
TimeoutScheduler {
    private final long connectionCount;
    private final String connectionId;
    @NotNull
    private final String id;
    private final MySQLConnectionHandler connectionHandler;
    private final CompletableFuture<MySQLConnection> connectionPromise;
    private final CompletableFuture<Connection> disconnectionPromise;
    private final AtomicReference<Optional<CompletableFuture<QueryResult>>> queryPromiseReference;
    private boolean isStoredProcedureCall;
    private ResultSet lastResultSet;
    private boolean connected;
    private Throwable lastException;
    private KotlinVersion serverVersion;
    private int serverStatus;
    private final TimeoutSchedulerImpl timeoutSchedulerImpl;
    private boolean channelClosed;
    private boolean reportErrorAfterChannelClosed;
    @NotNull
    private static final AtomicLong Counter;
    @NotNull
    private static final KotlinVersion MicrosecondsVersion;
    private static final Regex regexForCallInQueryStart;
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return this.id;
    }

    public final boolean isAutoCommit() {
        return (this.serverStatus & 2) != 0;
    }

    @Nullable
    public final KotlinVersion version() {
        return this.serverVersion;
    }

    @Nullable
    public Throwable lastException() {
        return this.lastException;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<MySQLConnection> connect() {
        void $receiver$iv;
        CompletableFuture<MySQLConnectionHandler> completableFuture = this.connectionHandler.connect();
        Executor executor$iv = this.getConfiguration().getExecutionContext();
        boolean $i$f$onFailureAsync = false;
        Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.whenCompleteAsync(new BiConsumer<MySQLConnectionHandler, Throwable>(this){
            final /* synthetic */ MySQLConnection this$0;
            {
                this.this$0 = mySQLConnection;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void accept(Object $noName_0, Throwable t) {
                if (t != null) {
                    Throwable e = t;
                    boolean bl = false;
                    FutureUtilsKt.failed((CompletableFuture)MySQLConnection.access$getConnectionPromise$p(this.this$0), (Throwable)e);
                }
            }
        }, executor$iv), (String)"whenCompleteAsync(BiCons\u2026ailureFun(t) }, executor)");
        return this.connectionPromise;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<Connection> close() {
        MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<String>(this){
            final /* synthetic */ MySQLConnection this$0;

            @NotNull
            public final String invoke() {
                return "close connection " + MySQLConnection.access$getConnectionId$p(this.this$0);
            }
            {
                this.this$0 = mySQLConnection;
                super(0);
            }
        });
        this.channelClosed = true;
        DatabaseException exception = new DatabaseException("Connection is being closed");
        this.failQueryPromise((Throwable)exception);
        if (this.isConnected() && !FutureUtilsKt.isCompleted(this.disconnectionPromise)) {
            void $receiver$iv;
            MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<String>(this){
                final /* synthetic */ MySQLConnection this$0;

                @NotNull
                public final String invoke() {
                    return "send quit message " + MySQLConnection.access$getConnectionId$p(this.this$0);
                }
                {
                    this.this$0 = mySQLConnection;
                    super(0);
                }
            });
            CompletableFuture<Channel> completableFuture = this.connectionHandler.sendQuitMessage();
            Executor executor$iv = this.getConfiguration().getExecutionContext();
            boolean $i$f$onCompleteAsync = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.whenCompleteAsync(new BiConsumer<Channel, Throwable>(this){
                final /* synthetic */ MySQLConnection this$0;
                {
                    this.this$0 = mySQLConnection;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final void accept(Object a, Throwable t) {
                    Try ty1 = t != null ? Try.Companion.raise(t) : Try.Companion.just(a);
                    boolean bl = false;
                    Try try_ = ty1;
                    if (try_ instanceof Success) {
                        void $receiver$iv;
                        MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<String>(this){
                            final /* synthetic */ close$$inlined$onCompleteAsync$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "close channel " + MySQLConnection.access$getConnectionId$p(this.this$0.this$0);
                            }
                        });
                        CompletableFuture completableFuture = ChannelFutureTransformerKt.toCompletableFuture((ChannelFuture)MySQLConnection.access$getConnectionHandler$p(this.this$0).closeChannel());
                        Executor executor$iv = this.this$0.getConfiguration().getExecutionContext();
                        boolean $i$f$onCompleteAsync = false;
                        Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.whenCompleteAsync(new BiConsumer<ChannelFuture, Throwable>(this){
                            final /* synthetic */ close$$inlined$onCompleteAsync$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final void accept(Object a, Throwable t) {
                                Try ty2 = t != null ? Try.Companion.raise(t) : Try.Companion.just(a);
                                boolean bl = false;
                                MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<String>(this){
                                    final /* synthetic */ close$$inlined$onCompleteAsync$1$lambda$2 this$0;
                                    {
                                        this.this$0 = var1_1;
                                        super(0);
                                    }

                                    @NotNull
                                    public final String invoke() {
                                        return "channel was closed " + MySQLConnection.access$getConnectionId$p(this.this$0.this$0.this$0);
                                    }
                                });
                                Try try_ = ty2;
                                if (try_ instanceof Success) {
                                    MySQLConnection.access$getDisconnectionPromise$p(this.this$0.this$0).complete(this.this$0.this$0);
                                } else if (try_ instanceof Failure) {
                                    FutureUtilsKt.complete((CompletableFuture)MySQLConnection.access$getDisconnectionPromise$p(this.this$0.this$0), (Try)ty2);
                                }
                            }
                        }, executor$iv), (String)"whenCompleteAsync(BiCons\u2026Try.just(a)) }, executor)");
                    } else if (try_ instanceof Failure) {
                        FutureUtilsKt.complete((CompletableFuture)MySQLConnection.access$getDisconnectionPromise$p(this.this$0), (Try)ty1);
                    }
                }
            }, executor$iv), (String)"whenCompleteAsync(BiCons\u2026Try.just(a)) }, executor)");
        }
        return this.disconnectionPromise;
    }

    @Override
    public void unregistered() {
        MySQLConnectionKt.access$getLogger$p().debug((Function0)new Function0<String>(this){
            final /* synthetic */ MySQLConnection this$0;

            @NotNull
            public final String invoke() {
                return this.this$0.isQuerying() ? this.this$0.getId() + " - client got disconnected in the middle of query execution" : this.this$0.getId() + " - client got disconnected with no running query";
            }
            {
                this.this$0 = mySQLConnection;
                super(0);
            }
        });
        CompletableFuture<Connection> $receiver$iv = this.close();
        boolean $i$f$mapTry = false;
        Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.handle(new BiFunction<T, Throwable, U>(this){
            final /* synthetic */ MySQLConnection this$0;
            {
                this.this$0 = mySQLConnection;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Object apply(Object a, @Nullable Throwable t) {
                void throwable;
                Throwable throwable2 = t;
                Connection $noName_0 = (Connection)a;
                boolean bl = false;
                if (throwable != null) {
                    MySQLConnectionKt.access$getLogger$p().warn((Throwable)throwable, (Function0)new Function0<String>(this){
                        final /* synthetic */ unregistered$$inlined$mapTry$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "failed to unregister " + MySQLConnection.access$getConnectionId$p(this.this$0.this$0);
                        }
                    });
                }
                return Unit.INSTANCE;
            }
        }), (String)"handle { a, t: Throwable? -> f(a, t) }");
    }

    public boolean isTimeout() {
        return this.timeoutSchedulerImpl.isTimeout();
    }

    @Override
    public void connected(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        MySQLConnectionKt.access$getLogger$p().debug((Function0)new Function0<String>(this, ctx){
            final /* synthetic */ MySQLConnection this$0;
            final /* synthetic */ ChannelHandlerContext $ctx;

            @NotNull
            public final String invoke() {
                return MySQLConnection.access$getConnectionId$p(this.this$0) + " Connected to " + this.$ctx.channel().remoteAddress();
            }
            {
                this.this$0 = mySQLConnection;
                this.$ctx = channelHandlerContext;
                super(0);
            }
        });
        this.connected = true;
    }

    @Override
    public void exceptionCaught(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (this.channelClosed) {
            MySQLConnectionKt.access$getLogger$p().trace(exception, (Function0)new Function0<String>(this){
                final /* synthetic */ MySQLConnection this$0;

                @NotNull
                public final String invoke() {
                    return MySQLConnection.access$getConnectionId$p(this.this$0) + " Transport failure after connection close";
                }
                {
                    this.this$0 = mySQLConnection;
                    super(0);
                }
            });
            if (!this.reportErrorAfterChannelClosed) {
                MySQLConnectionKt.access$getLogger$p().info((Function0)new Function0<String>(this, exception){
                    final /* synthetic */ MySQLConnection this$0;
                    final /* synthetic */ Throwable $exception;

                    @NotNull
                    public final String invoke() {
                        return MySQLConnection.access$getConnectionId$p(this.this$0) + " Transport failure after connection close: " + this.$exception.getMessage();
                    }
                    {
                        this.this$0 = mySQLConnection;
                        this.$exception = throwable;
                        super(0);
                    }
                });
                this.reportErrorAfterChannelClosed = true;
            }
        }
        MySQLConnectionKt.access$getLogger$p().error(this.connectionId + " Transport failure ", exception);
        this.setException(exception);
    }

    @Override
    public void onError(@NotNull ErrorMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        MySQLConnectionKt.access$getLogger$p().error(this.connectionId + " Received an error message -> {}", (Object)message);
        MySQLException exception = new MySQLException(message);
        this.setException((Throwable)((Object)exception));
    }

    private final void setException(Throwable t) {
        this.lastException = t;
        FutureUtilsKt.failed(this.connectionPromise, (Throwable)t);
        this.failQueryPromise(t);
    }

    @Override
    public void onOk(@NotNull OkMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.serverStatus = message.getStatusFlags();
        if (!FutureUtilsKt.isCompleted(this.connectionPromise)) {
            MySQLConnectionKt.access$getLogger$p().debug(this.connectionId + " Connected to database");
            FutureUtilsKt.success(this.connectionPromise, (Object)this);
        } else if (this.isQuerying()) {
            if (this.isStoredProcedureCall) {
                this.succeedQueryPromise(new MySQLQueryResult(message.getAffectedRows(), message.getMessage(), message.getLastInsertId(), message.getStatusFlags(), message.getWarnings(), this.lastResultSet));
            } else {
                this.succeedQueryPromise(new MySQLQueryResult(message.getAffectedRows(), message.getMessage(), message.getLastInsertId(), message.getStatusFlags(), message.getWarnings(), null, 32, null));
            }
        } else {
            MySQLConnectionKt.access$getLogger$p().warn(this.connectionId + " Received OK when not querying or connecting, not sure what this is: " + message);
        }
    }

    @Override
    public void onEOF(@NotNull EOFMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        MySQLConnectionKt.access$getLogger$p().debug((Function0)new Function0<String>(this){
            final /* synthetic */ MySQLConnection this$0;

            @NotNull
            public final String invoke() {
                return MySQLConnection.access$getConnectionId$p(this.this$0) + " onEOF isStoredProcedureCall=" + MySQLConnection.access$isStoredProcedureCall$p(this.this$0) + " isQuerying=" + this.this$0.isQuerying();
            }
            {
                this.this$0 = mySQLConnection;
                super(0);
            }
        });
        this.serverStatus = message.getFlags();
        if (this.isQuerying() && !this.isStoredProcedureCall) {
            this.succeedQueryPromise(new MySQLQueryResult(0L, null, -1L, message.getFlags(), message.getWarningCount(), null, 32, null));
        }
    }

    @Override
    public void onHandshake(@NotNull HandshakeMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.serverVersion = VersionKt.parseVersion((String)message.getServerVersion());
        this.serverStatus = message.getStatusFlags();
        String string = this.getConfiguration().getApplicationName();
        String string2 = this.getConfiguration().getPassword();
        String string3 = this.getConfiguration().getDatabase();
        this.connectionHandler.write(new HandshakeResponseMessage(this.getConfiguration().getUsername(), this.getConfiguration().getCharset(), message.getSeed(), message.getAuthenticationMethod(), string2, string3, string));
    }

    @Override
    public void switchAuthentication(@NotNull AuthenticationSwitchRequest message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.connectionHandler.write(new AuthenticationSwitchResponse(this.getConfiguration().getPassword(), message));
    }

    @NotNull
    public CompletableFuture<QueryResult> sendQueryDirect(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<String>(this, query){
            final /* synthetic */ MySQLConnection this$0;
            final /* synthetic */ String $query;

            @NotNull
            public final String invoke() {
                return MySQLConnection.access$getConnectionId$p(this.this$0) + " sendQuery() - " + this.$query;
            }
            {
                this.this$0 = mySQLConnection;
                this.$query = string;
                super(0);
            }
        });
        this.validateIsReadyForQuery();
        CompletableFuture<QueryResult> promise = new CompletableFuture<QueryResult>();
        this.setQueryPromise(promise);
        this.checkStoredProcedureCall(query);
        this.connectionHandler.sendQuery(query);
        this.timeoutSchedulerImpl.addTimeout(promise, this.getConfiguration().getQueryTimeout(), this.connectionId);
        return promise;
    }

    private final void failQueryPromise(Throwable t) {
        this.clearQueryPromise().ifPresent(new Consumer<CompletableFuture<QueryResult>>(t){
            final /* synthetic */ Throwable $t;

            public final void accept(@NotNull CompletableFuture<QueryResult> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                FutureUtilsKt.failed(it, (Throwable)this.$t);
            }
            {
                this.$t = throwable;
            }
        });
    }

    private final void succeedQueryPromise(QueryResult queryResult) {
        this.clearQueryPromise().ifPresent(new Consumer<CompletableFuture<QueryResult>>(queryResult){
            final /* synthetic */ QueryResult $queryResult;

            public final void accept(@NotNull CompletableFuture<QueryResult> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                FutureUtilsKt.success(it, (Object)this.$queryResult);
            }
            {
                this.$queryResult = queryResult;
            }
        });
    }

    public boolean isQuerying() {
        return this.queryPromise().isPresent();
    }

    @Override
    public void onResultSet(@NotNull ResultSet resultSet, @NotNull EOFMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.isQuerying()) {
            if (this.isStoredProcedureCall) {
                this.lastResultSet = resultSet;
            } else {
                this.succeedQueryPromise(new MySQLQueryResult(resultSet.size(), null, -1L, message.getFlags(), message.getWarningCount(), resultSet));
            }
        } else {
            MySQLConnectionKt.access$getLogger$p().warn((Function0)new Function0<String>(this){
                final /* synthetic */ MySQLConnection this$0;

                @NotNull
                public final String invoke() {
                    return MySQLConnection.access$getConnectionId$p(this.this$0) + " onResultSet - called without active query";
                }
                {
                    this.this$0 = mySQLConnection;
                    super(0);
                }
            });
        }
    }

    @NotNull
    public CompletableFuture<Connection> disconnect() {
        return this.close();
    }

    private final void onTimeout() {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connectionHandler.isConnected();
    }

    public boolean hasRecentError() {
        return this.lastException != null;
    }

    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatementDirect(@NotNull PreparedStatementParams params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<String>(this, params){
            final /* synthetic */ MySQLConnection this$0;
            final /* synthetic */ PreparedStatementParams $params;

            @NotNull
            public final String invoke() {
                return MySQLConnection.access$getConnectionId$p(this.this$0) + " sendPreparedStatement() - " + this.$params;
            }
            {
                this.this$0 = mySQLConnection;
                this.$params = preparedStatementParams;
                super(0);
            }
        });
        this.validateIsReadyForQuery();
        CharSequence $this$count$iv = params.getQuery();
        boolean $i$f$count = false;
        int count$iv = 0;
        CharSequence charSequence = $this$count$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv;
            char it = element$iv = charSequence.charAt(i);
            boolean bl = false;
            if (!(it == '?')) continue;
            ++count$iv;
        }
        int totalParameters = count$iv;
        if (CollectionsUtilsKt.getLength((Collection)params.getValues()) != totalParameters) {
            throw (Throwable)new InsufficientParametersException(totalParameters, params.getValues());
        }
        CompletableFuture<QueryResult> promise = new CompletableFuture<QueryResult>();
        this.setQueryPromise(promise);
        this.checkStoredProcedureCall(params.getQuery());
        this.connectionHandler.sendPreparedStatement(params.getQuery(), params.getValues());
        this.timeoutSchedulerImpl.addTimeout(promise, this.getConfiguration().getQueryTimeout(), this.connectionId);
        CompletableFuture closedPromise = this.releaseIfNeeded(params.getRelease(), promise, params.getQuery());
        return closedPromise;
    }

    private final void checkStoredProcedureCall(String query) {
        CharSequence charSequence = query;
        Regex regex = regexForCallInQueryStart;
        boolean bl = false;
        if (regex.matches(charSequence)) {
            this.isStoredProcedureCall = true;
        }
    }

    @NotNull
    public CompletableFuture<Boolean> releasePreparedStatement(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        this.validateIsReadyForQuery();
        return this.connectionHandler.closePreparedStatement(query);
    }

    @NotNull
    public String toString() {
        String string = "%s(%s,%d)";
        Object[] objectArray = new Object[]{this.getClass().getName(), this.connectionId, this.connectionCount};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    private final void validateIsReadyForQuery() {
        if (!this.isConnected()) {
            throw (Throwable)new IllegalStateException("not connected so can't execute queries. please make sure connect() was called and disconnect() was not called.");
        }
        if (this.isQuerying()) {
            throw (Throwable)new ConnectionStillRunningQueryException(this.getId(), false);
        }
    }

    private final Optional<CompletableFuture<QueryResult>> queryPromise() {
        Optional<CompletableFuture<QueryResult>> optional = this.queryPromiseReference.get();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"queryPromiseReference.get()");
        return optional;
    }

    private final void setQueryPromise(CompletableFuture<QueryResult> promise) {
        if (!this.queryPromiseReference.compareAndSet(Optional.empty(), Optional.of(promise))) {
            throw (Throwable)new ConnectionStillRunningQueryException(this.getId(), true);
        }
    }

    private final Optional<CompletableFuture<QueryResult>> clearQueryPromise() {
        Optional<CompletableFuture<QueryResult>> currentPromise;
        Optional<CompletableFuture<QueryResult>> optional = currentPromise = this.queryPromiseReference.getAndSet(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"currentPromise");
        if (optional.isPresent()) {
            this.isStoredProcedureCall = false;
            this.lastResultSet = ResultSetKt.getEMPTY_RESULT_SET();
        }
        return currentPromise;
    }

    @JvmOverloads
    public MySQLConnection(@NotNull Configuration configuration, @NotNull CharsetMapper charsetMapper) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)charsetMapper, (String)"charsetMapper");
        super(configuration);
        charsetMapper.toInt(configuration.getCharset());
        this.connectionCount = Counter.incrementAndGet();
        this.id = this.connectionId = "<mysql-connection-" + this.connectionCount + '>';
        this.connectionHandler = new MySQLConnectionHandler(configuration, charsetMapper, this, configuration.getEventLoopGroup(), configuration.getExecutionContext(), this.connectionId);
        this.connectionPromise = new CompletableFuture();
        this.disconnectionPromise = new CompletableFuture();
        this.queryPromiseReference = new AtomicReference(Optional.empty());
        this.lastResultSet = ResultSetKt.getEMPTY_RESULT_SET();
        this.timeoutSchedulerImpl = new TimeoutSchedulerImpl(configuration.getExecutionContext(), configuration.getEventLoopGroup(), (Function0)new Function0<Unit>(this){

            public final void invoke() {
                MySQLConnection.access$onTimeout((MySQLConnection)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MySQLConnection.class);
            }

            public final String getName() {
                return "onTimeout";
            }

            public final String getSignature() {
                return "onTimeout()V";
            }
        });
    }

    @JvmOverloads
    public /* synthetic */ MySQLConnection(Configuration configuration, CharsetMapper charsetMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charsetMapper = CharsetMapper.Companion.getInstance();
        }
        this(configuration, charsetMapper);
    }

    @JvmOverloads
    public MySQLConnection(@NotNull Configuration configuration) {
        this(configuration, null, 2, null);
    }

    static {
        Companion = new Companion(null);
        Counter = new AtomicLong();
        MicrosecondsVersion = new KotlinVersion(5, 6, 0);
        regexForCallInQueryStart = new Regex("\\s*call\\s+.*", RegexOption.IGNORE_CASE);
    }

    public static final /* synthetic */ CompletableFuture access$getConnectionPromise$p(MySQLConnection $this) {
        return $this.connectionPromise;
    }

    public static final /* synthetic */ String access$getConnectionId$p(MySQLConnection $this) {
        return $this.connectionId;
    }

    public static final /* synthetic */ MySQLConnectionHandler access$getConnectionHandler$p(MySQLConnection $this) {
        return $this.connectionHandler;
    }

    public static final /* synthetic */ CompletableFuture access$getDisconnectionPromise$p(MySQLConnection $this) {
        return $this.disconnectionPromise;
    }

    public static final /* synthetic */ boolean access$isStoredProcedureCall$p(MySQLConnection $this) {
        return $this.isStoredProcedureCall;
    }

    public static final /* synthetic */ void access$setStoredProcedureCall$p(MySQLConnection $this, boolean bl) {
        $this.isStoredProcedureCall = bl;
    }

    public static final /* synthetic */ void access$onTimeout(MySQLConnection $this) {
        $this.onTimeout();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/jasync/sql/db/mysql/MySQLConnection$StatusFlags;", "", "()V", "AUTO_COMMIT", "", "jasync-mysql"})
    public static final class StatusFlags {
        public static final int AUTO_COMMIT = 2;
        public static final StatusFlags INSTANCE;

        private StatusFlags() {
        }

        static {
            StatusFlags statusFlags;
            INSTANCE = statusFlags = new StatusFlags();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/jasync/sql/db/mysql/MySQLConnection$Companion;", "", "()V", "Counter", "Ljava/util/concurrent/atomic/AtomicLong;", "getCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "MicrosecondsVersion", "Lkotlin/KotlinVersion;", "Lcom/github/jasync/sql/db/util/Version;", "MicrosecondsVersion$annotations", "getMicrosecondsVersion", "()Lkotlin/KotlinVersion;", "regexForCallInQueryStart", "Lkotlin/text/Regex;", "jasync-mysql"})
    public static final class Companion {
        @NotNull
        public final AtomicLong getCounter() {
            return Counter;
        }

        public static /* synthetic */ void MicrosecondsVersion$annotations() {
        }

        @NotNull
        public final KotlinVersion getMicrosecondsVersion() {
            return MicrosecondsVersion;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

