/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.pool;

import com.github.jasync.sql.db.ConcreteConnection;
import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.exceptions.ConnectionNotConnectedException;
import com.github.jasync.sql.db.exceptions.ConnectionStillRunningQueryException;
import com.github.jasync.sql.db.exceptions.ConnectionTimeoutedException;
import com.github.jasync.sql.db.pool.ConnectionFactoryKt;
import com.github.jasync.sql.db.pool.ObjectFactory;
import com.github.jasync.sql.db.util.FP;
import com.github.jasync.sql.db.util.Failure;
import com.github.jasync.sql.db.util.Success;
import com.github.jasync.sql.db.util.Try;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/jasync/sql/db/pool/ConnectionFactory;", "T", "Lcom/github/jasync/sql/db/ConcreteConnection;", "Lcom/github/jasync/sql/db/pool/ObjectFactory;", "()V", "testCounter", "", "destroy", "", "item", "(Lcom/github/jasync/sql/db/ConcreteConnection;)V", "test", "Ljava/util/concurrent/CompletableFuture;", "(Lcom/github/jasync/sql/db/ConcreteConnection;)Ljava/util/concurrent/CompletableFuture;", "validate", "Lcom/github/jasync/sql/db/util/Try;", "(Lcom/github/jasync/sql/db/ConcreteConnection;)Lcom/github/jasync/sql/db/util/Try;", "jasync-common"})
public abstract class ConnectionFactory<T extends ConcreteConnection>
implements ObjectFactory<T> {
    private int testCounter;

    @Override
    public void destroy(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        try {
            item.disconnect();
        }
        catch (Exception e) {
            ConnectionFactoryKt.access$getLogger$p().error("Failed to close the connection", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public Try<T> validate(@NotNull T item) {
        Try try_;
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        Try.Companion this_$iv = Try.Companion;
        boolean $i$f$invoke = false;
        try {
            T t;
            boolean bl = false;
            if (item.isTimeout()) {
                throw (Throwable)new ConnectionTimeoutedException((Connection)item);
            }
            if (!item.isConnected()) {
                throw (Throwable)new ConnectionNotConnectedException((Connection)item);
            }
            Throwable throwable = item.lastException();
            if (throwable != null) {
                Throwable throwable2 = throwable;
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable it = throwable2;
                boolean bl4 = false;
                throw it;
            }
            if (item.isQuerying()) {
                throw (Throwable)new ConnectionStillRunningQueryException(item.getId(), false);
            }
            T t2 = t = item;
            try_ = new Success<T>(t2);
        }
        catch (Throwable e$iv) {
            try_ = new Failure(e$iv);
        }
        return try_;
    }

    @Override
    @NotNull
    public CompletableFuture<T> test(@NotNull T item) {
        CompletionStage<Object> completionStage;
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        try {
            CompletionStage completionStage2;
            boolean $i$f$map;
            CompletableFuture<QueryResult> $receiver$iv;
            int n = this.testCounter;
            this.testCounter = n + 1;
            if (n % 2 == 0) {
                $receiver$iv = item.sendPreparedStatement("SELECT 0", CollectionsKt.emptyList(), true);
                $i$f$map = false;
                CompletionStage completionStage3 = $receiver$iv.thenApply(new Function<T, U>((ConcreteConnection)item){
                    final /* synthetic */ ConcreteConnection $item$inlined;
                    {
                        this.$item$inlined = concreteConnection;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final Object apply(Object it) {
                        QueryResult it2 = (QueryResult)it;
                        boolean bl = false;
                        return this.$item$inlined;
                    }
                });
                completionStage2 = completionStage3;
                Intrinsics.checkExpressionValueIsNotNull((Object)completionStage3, (String)"thenApply { f(it) }");
            } else {
                $receiver$iv = item.sendQuery("SELECT 0");
                $i$f$map = false;
                CompletionStage completionStage4 = $receiver$iv.thenApply(new Function<T, U>((ConcreteConnection)item){
                    final /* synthetic */ ConcreteConnection $item$inlined;
                    {
                        this.$item$inlined = concreteConnection;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final Object apply(Object it) {
                        QueryResult it2 = (QueryResult)it;
                        boolean bl = false;
                        return this.$item$inlined;
                    }
                });
                completionStage2 = completionStage4;
                Intrinsics.checkExpressionValueIsNotNull((Object)completionStage4, (String)"thenApply { f(it) }");
            }
            completionStage = completionStage2;
        }
        catch (Exception e) {
            completionStage = FP.INSTANCE.failed(e);
        }
        return completionStage;
    }
}

