/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.validation.metric.Averaging;
import smile.validation.metric.ClassificationMetric;
import smile.validation.metric.Precision;
import smile.validation.metric.Recall;

public class FScore
implements ClassificationMetric {
    private static final long serialVersionUID = 2L;
    public static final FScore F1 = new FScore(1.0, null);
    public static final FScore F2 = new FScore(2.0, null);
    public static final FScore FHalf = new FScore(0.5, null);
    private final double beta;
    private final Averaging strategy;

    public FScore() {
        this(1.0, null);
    }

    public FScore(double beta, Averaging strategy) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("Negative beta");
        }
        this.beta = beta;
        this.strategy = strategy;
    }

    @Override
    public double score(int[] truth, int[] prediction) {
        return FScore.of(truth, prediction, this.beta, this.strategy);
    }

    public String toString() {
        return String.format("F-Score(%f%s)", this.beta, this.strategy == null ? "" : ", " + String.valueOf((Object)this.strategy));
    }

    public static double of(int[] truth, int[] prediction, double beta, Averaging strategy) {
        double beta2 = beta * beta;
        double p = Precision.of(truth, prediction, strategy);
        double r = Recall.of(truth, prediction, strategy);
        return (1.0 + beta2) * (p * r) / (beta2 * p + r);
    }
}

