/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.io.Serializable;
import java.util.List;
import smile.math.MathEx;
import smile.validation.RegressionMetrics;
import smile.validation.RegressionValidation;

public class RegressionValidations<M>
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final List<RegressionValidation<M>> rounds;
    public final RegressionMetrics avg;
    public final RegressionMetrics sd;

    public RegressionValidations(List<RegressionValidation<M>> rounds) {
        this.rounds = rounds;
        int k = rounds.size();
        double[] fitTime = new double[k];
        double[] scoreTime = new double[k];
        int[] size = new int[k];
        double[] rss = new double[k];
        double[] mse = new double[k];
        double[] rmse = new double[k];
        double[] mad = new double[k];
        double[] r2 = new double[k];
        for (int i = 0; i < k; ++i) {
            RegressionMetrics metrics = rounds.get((int)i).metrics;
            fitTime[i] = metrics.fitTime();
            scoreTime[i] = metrics.scoreTime();
            size[i] = metrics.size();
            rss[i] = metrics.rss();
            mse[i] = metrics.mse();
            rmse[i] = metrics.rmse();
            mad[i] = metrics.mad();
            r2[i] = metrics.r2();
        }
        this.avg = new RegressionMetrics(MathEx.mean((double[])fitTime), MathEx.mean((double[])scoreTime), (int)Math.round(MathEx.mean((int[])size)), MathEx.mean((double[])rss), MathEx.mean((double[])mse), MathEx.mean((double[])rmse), MathEx.mean((double[])mad), MathEx.mean((double[])r2));
        this.sd = new RegressionMetrics(MathEx.sd((double[])fitTime), MathEx.sd((double[])scoreTime), (int)Math.round(MathEx.sd((int[])size)), MathEx.sd((double[])rss), MathEx.sd((double[])mse), MathEx.sd((double[])rmse), MathEx.sd((double[])mad), MathEx.sd((double[])r2));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        sb.append(String.format("  fit time: %.3f ms \u00b1 %.3f,\n", this.avg.fitTime(), this.sd.fitTime()));
        sb.append(String.format("  score time: %.3f ms \u00b1 %.3f,\n", this.avg.scoreTime(), this.sd.scoreTime()));
        sb.append(String.format("  validation data size:: %d \u00b1 %d,\n", this.avg.size(), this.sd.size()));
        sb.append(String.format("  RSS: %.4f \u00b1 %.4f,\n", this.avg.rss(), this.sd.rss()));
        sb.append(String.format("  MSE: %.4f \u00b1 %.4f,\n", this.avg.mse(), this.sd.mse()));
        sb.append(String.format("  RMSE: %.4f \u00b1 %.4f,\n", this.avg.rmse(), this.sd.rmse()));
        sb.append(String.format("  MAD: %.4f \u00b1 %.4f,\n", this.avg.mad(), this.sd.mad()));
        sb.append(String.format("  R2: %.2f%% \u00b1 %.2f\n}", 100.0 * this.avg.r2(), 100.0 * this.sd.r2()));
        return sb.toString();
    }
}

