/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.io.Serializable;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Formula;
import smile.regression.DataFrameRegression;
import smile.regression.Regression;
import smile.validation.metric.MAD;
import smile.validation.metric.MSE;
import smile.validation.metric.R2;
import smile.validation.metric.RMSE;
import smile.validation.metric.RSS;

public record RegressionMetrics(double fitTime, double scoreTime, int size, double rss, double mse, double rmse, double mad, double r2) implements Serializable
{
    private static final long serialVersionUID = 3L;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        if (!Double.isNaN(this.fitTime)) {
            sb.append(String.format("  fit time: %.3f ms,\n", this.fitTime));
        }
        sb.append(String.format("  score time: %.3f ms,\n", this.scoreTime));
        sb.append(String.format("  validation data size:: %d,\n", this.size));
        sb.append(String.format("  RSS: %.4f,\n", this.rss));
        sb.append(String.format("  MSE: %.4f,\n", this.mse));
        sb.append(String.format("  RMSE: %.4f,\n", this.rmse));
        sb.append(String.format("  MAD: %.4f,\n", this.mad));
        sb.append(String.format("  R2: %.2f%%\n}", 100.0 * this.r2));
        return sb.toString();
    }

    public static RegressionMetrics of(double fitTime, double scoreTime, double[] truth, double[] prediction) {
        return new RegressionMetrics(fitTime, scoreTime, truth.length, RSS.of(truth, prediction), MSE.of(truth, prediction), RMSE.of(truth, prediction), MAD.of(truth, prediction), R2.of(truth, prediction));
    }

    public static <T, M extends Regression<T>> RegressionMetrics of(M model, T[] testx, double[] testy) {
        return RegressionMetrics.of(Double.NaN, model, testx, testy);
    }

    public static <T, M extends Regression<T>> RegressionMetrics of(double fitTime, M model, T[] testx, double[] testy) {
        long start = System.nanoTime();
        double[] prediction = model.predict(testx);
        double scoreTime = (double)(System.nanoTime() - start) / 1000000.0;
        return new RegressionMetrics(fitTime, scoreTime, testy.length, RSS.of(testy, prediction), MSE.of(testy, prediction), RMSE.of(testy, prediction), MAD.of(testy, prediction), R2.of(testy, prediction));
    }

    public static <M extends DataFrameRegression> RegressionMetrics of(M model, Formula formula, DataFrame test) {
        return RegressionMetrics.of(Double.NaN, model, formula, test);
    }

    public static <M extends DataFrameRegression> RegressionMetrics of(double fitTime, M model, Formula formula, DataFrame test) {
        double[] testy = formula.y(test).toDoubleArray();
        long start = System.nanoTime();
        int n = test.nrow();
        double[] prediction = new double[n];
        for (int i = 0; i < n; ++i) {
            prediction[i] = model.predict((Tuple)test.get(i));
        }
        double scoreTime = (double)(System.nanoTime() - start) / 1000000.0;
        return new RegressionMetrics(fitTime, scoreTime, testy.length, RSS.of(testy, prediction), MSE.of(testy, prediction), RMSE.of(testy, prediction), MAD.of(testy, prediction), R2.of(testy, prediction));
    }
}

