/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.manifold.MDS;
import smile.math.MathEx;

public class SammonMapping {
    private static final Logger logger = LoggerFactory.getLogger(SammonMapping.class);
    public final double stress;
    public final double[][] coordinates;

    public SammonMapping(double stress, double[][] coordinates) {
        this.stress = stress;
        this.coordinates = coordinates;
    }

    public static SammonMapping of(double[][] proximity) {
        return SammonMapping.of(proximity, new Properties());
    }

    public static SammonMapping of(double[][] proximity, int k) {
        return SammonMapping.of(proximity, k, 0.2, 1.0E-4, 0.001, 100);
    }

    public static SammonMapping of(double[][] proximity, Properties params) {
        int k = Integer.parseInt(params.getProperty("smile.sammon.k", "2"));
        double lambda = Double.parseDouble(params.getProperty("smile.sammon.lambda", "0.2"));
        double tol = Double.parseDouble(params.getProperty("smile.sammon.tolerance", "1E-4"));
        double stepTol = Double.parseDouble(params.getProperty("smile.sammon.step_tolerance", "1E-3"));
        int maxIter = Integer.parseInt(params.getProperty("smile.sammon.iterations", "100"));
        return SammonMapping.of(proximity, k, lambda, tol, stepTol, maxIter);
    }

    public static SammonMapping of(double[][] proximity, int k, double lambda, double tol, double stepTol, int maxIter) {
        return SammonMapping.of(proximity, MDS.of((double[][])proximity, (int)k).coordinates, lambda, tol, stepTol, maxIter);
    }

    public static SammonMapping of(double[][] proximity, double[][] init, double lambda, double tol, double stepTol, int maxIter) {
        if (proximity.length != proximity[0].length) {
            throw new IllegalArgumentException("The proximity matrix is not square.");
        }
        if (proximity.length != init.length) {
            throw new IllegalArgumentException("The proximity matrix and the initial coordinates are of different size.");
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tolerance: " + tol);
        }
        if (maxIter <= 0) {
            throw new IllegalArgumentException("Invalid maximum number of iterations: " + maxIter);
        }
        int n = proximity.length;
        double[][] coordinates = init;
        double c = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                c += proximity[i][j];
            }
        }
        int k = coordinates[0].length;
        double[][] xu = new double[n][k];
        double stress = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double dij = proximity[i][j];
                if (dij == 0.0) {
                    dij = 1.0E-10;
                }
                double rij = MathEx.distance((double[])coordinates[i], (double[])coordinates[j]);
                stress += MathEx.pow2((double)(dij - rij)) / dij;
            }
        }
        double epast = stress /= c;
        double eprev = stress;
        logger.info("Sammon's Mapping initial stress: {}", (Object)stress);
        double[] xv = new double[k];
        double[] e1 = new double[k];
        double[] e2 = new double[k];
        for (int iter = 1; iter <= maxIter; ++iter) {
            int i;
            for (i = 0; i < n; ++i) {
                double[] ri = coordinates[i];
                Arrays.fill(e1, 0.0);
                Arrays.fill(e2, 0.0);
                for (int j = 0; j < n; ++j) {
                    if (i == j) continue;
                    double[] rj = coordinates[j];
                    double dij = proximity[i][j];
                    if (dij == 0.0) {
                        dij = 1.0E-10;
                    }
                    double rij = 0.0;
                    for (int l = 0; l < k; ++l) {
                        double xd = ri[l] - rj[l];
                        rij += xd * xd;
                        xv[l] = xd;
                    }
                    if ((rij = Math.sqrt(rij)) == 0.0) {
                        rij = 1.0E-10;
                    }
                    double dq = dij - rij;
                    double dr = dij * rij;
                    for (int l = 0; l < k; ++l) {
                        int n2 = l;
                        e1[n2] = e1[n2] + xv[l] * dq / dr;
                        int n3 = l;
                        e2[n3] = e2[n3] + (dq - xv[l] * xv[l] * (1.0 + dq / rij) / rij) / dr;
                    }
                }
                for (int l = 0; l < k; ++l) {
                    xu[i][l] = ri[l] + lambda * e1[l] / Math.abs(e2[l]);
                }
            }
            stress = 0.0;
            for (i = 0; i < n; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    double dij = proximity[i][j];
                    if (dij == 0.0) {
                        dij = 1.0E-10;
                    }
                    double rij = MathEx.distance((double[])xu[i], (double[])xu[j]);
                    stress += MathEx.pow2((double)(dij - rij)) / dij;
                }
            }
            if ((stress /= c) > eprev) {
                stress = eprev;
                if ((lambda *= 0.2) < stepTol) {
                    logger.info("Sammon's Mapping stops early as stress = {} after {} iterations", (Object)stress, (Object)(iter - 1));
                    break;
                }
                --iter;
                continue;
            }
            if ((lambda *= 1.5) > 0.5) {
                lambda = 0.5;
            }
            eprev = stress;
            double[] mu = MathEx.colMeans((double[][])xu);
            for (int i2 = 0; i2 < n; ++i2) {
                for (int j = 0; j < k; ++j) {
                    coordinates[i2][j] = xu[i2][j] - mu[j];
                }
            }
            if (iter % 10 != 0) continue;
            logger.info("Sammon's Mapping stress after {} iterations: {}, magic = {}", new Object[]{iter, stress, lambda});
            if (stress > epast - tol) break;
            epast = stress;
        }
        return new SammonMapping(stress, coordinates);
    }
}

