/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import java.util.Arrays;
import smile.clustering.linkage.Linkage;
import smile.math.distance.Distance;

public class WardLinkage
extends Linkage {
    private int[] n;

    public WardLinkage(double[][] proximity) {
        super(proximity);
        this.init();
    }

    public WardLinkage(int size, float[] proximity) {
        super(size, proximity);
        this.init();
    }

    private void init() {
        this.n = new int[this.size];
        Arrays.fill(this.n, 1);
        for (int i = 0; i < this.proximity.length; ++i) {
            int n = i;
            this.proximity[n] = this.proximity[n] * this.proximity[i];
        }
    }

    public static WardLinkage of(double[][] data) {
        return new WardLinkage(data.length, WardLinkage.proximity(data));
    }

    public static <T> WardLinkage of(T[] data, Distance<T> distance) {
        return new WardLinkage(data.length, WardLinkage.proximity(data, distance));
    }

    public String toString() {
        return "Ward's linkage";
    }

    @Override
    public void merge(int i, int j) {
        int k;
        float nij = this.n[i] + this.n[j];
        for (k = 0; k < i; ++k) {
            this.proximity[this.index((int)i, (int)k)] = (this.d(i, k) * (float)(this.n[i] + this.n[k]) + this.d(j, k) * (float)(this.n[j] + this.n[k]) - this.d(j, i) * (float)this.n[k]) / (nij + (float)this.n[k]);
        }
        for (k = i + 1; k < j; ++k) {
            this.proximity[this.index((int)k, (int)i)] = (this.d(k, i) * (float)(this.n[i] + this.n[k]) + this.d(j, k) * (float)(this.n[j] + this.n[k]) - this.d(j, i) * (float)this.n[k]) / (nij + (float)this.n[k]);
        }
        for (k = j + 1; k < this.size; ++k) {
            this.proximity[this.index((int)k, (int)i)] = (this.d(k, i) * (float)(this.n[i] + this.n[k]) + this.d(k, j) * (float)(this.n[j] + this.n[k]) - this.d(j, i) * (float)this.n[k]) / (nij + (float)this.n[k]);
        }
        int n = i;
        this.n[n] = this.n[n] + this.n[j];
    }
}

