/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering.linkage;

import java.util.Arrays;
import smile.clustering.linkage.Linkage;
import smile.math.distance.Distance;

public class UPGMALinkage
extends Linkage {
    private int[] n;

    public UPGMALinkage(double[][] proximity) {
        super(proximity);
        this.init();
    }

    public UPGMALinkage(int size, float[] proximity) {
        super(size, proximity);
        this.init();
    }

    private void init() {
        this.n = new int[this.size];
        Arrays.fill(this.n, 1);
    }

    public static UPGMALinkage of(double[][] data) {
        return new UPGMALinkage(data.length, UPGMALinkage.proximity(data));
    }

    public static <T> UPGMALinkage of(T[] data, Distance<T> distance) {
        return new UPGMALinkage(data.length, UPGMALinkage.proximity(data, distance));
    }

    public String toString() {
        return "UPGMA linkage";
    }

    @Override
    public void merge(int i, int j) {
        int k;
        float sum = this.n[i] + this.n[j];
        for (k = 0; k < i; ++k) {
            this.proximity[this.index((int)i, (int)k)] = this.d(i, k) * (float)this.n[i] / sum + this.d(j, k) * (float)this.n[j] / sum;
        }
        for (k = i + 1; k < this.size; ++k) {
            this.proximity[this.index((int)k, (int)i)] = this.d(k, i) * (float)this.n[i] / sum + this.d(j, k) * (float)this.n[j] / sum;
        }
        int n = i;
        this.n[n] = this.n[n] + this.n[j];
    }
}

