/*
 * Decompiled with CFR 0.152.
 */
package smile.base.cart;

import java.math.BigInteger;
import java.util.List;
import smile.base.cart.InternalNode;
import smile.base.cart.LeafNode;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.math.MathEx;

public class RegressionNode
extends LeafNode {
    private static final long serialVersionUID = 2L;
    private final double mean;
    private final double output;
    private final double rss;

    public RegressionNode(int size, double output, double mean, double rss) {
        super(size);
        this.output = output;
        this.mean = mean;
        this.rss = rss;
    }

    public double output() {
        return this.output;
    }

    public double mean() {
        return this.mean;
    }

    public double impurity() {
        return this.rss;
    }

    @Override
    public double deviance() {
        return this.rss;
    }

    @Override
    public String dot(StructType schema, StructField response, int id) {
        return String.format(" %d [label=<%s = %.4f<br/>size = %d<br/>deviance = %.4f>, fillcolor=\"#00000000\", shape=ellipse];\n", id, response.name, this.output, this.size, this.rss);
    }

    @Override
    public int[] toString(StructType schema, StructField response, InternalNode parent, int depth, BigInteger id, List<String> lines) {
        StringBuilder line = new StringBuilder();
        line.append(" ".repeat(depth));
        line.append(id).append(") ");
        line.append(parent == null ? "root" : parent.toString(schema, this == parent.trueChild)).append(" ");
        line.append(this.size).append(" ");
        line.append(String.format("%.5g", this.rss)).append(" ");
        line.append(String.format("%g", this.output));
        line.append(" *");
        lines.add(line.toString());
        return new int[]{this.size};
    }

    public boolean equals(Object o) {
        if (o instanceof RegressionNode) {
            RegressionNode a = (RegressionNode)o;
            return MathEx.equals((double)this.output, (double)a.output);
        }
        return false;
    }
}

