/*
 * Decompiled with CFR 0.152.
 */
package smile.base.cart;

import java.util.Arrays;
import java.util.stream.Collectors;
import smile.base.cart.InternalNode;
import smile.base.cart.LeafNode;
import smile.base.cart.Node;
import smile.data.Tuple;
import smile.data.measure.Measure;
import smile.data.measure.NominalScale;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class NominalNode
extends InternalNode {
    private static final long serialVersionUID = 2L;
    final int value;

    public NominalNode(int feature, int value, double score, double deviance, Node trueChild, Node falseChild) {
        super(feature, score, deviance, trueChild, falseChild);
        this.value = value;
    }

    @Override
    public LeafNode predict(Tuple x) {
        return x.getInt(this.feature) == this.value ? this.trueChild.predict(x) : this.falseChild.predict(x);
    }

    @Override
    public boolean branch(Tuple x) {
        return x.getInt(this.feature) == this.value;
    }

    @Override
    public NominalNode replace(Node trueChild, Node falseChild) {
        return new NominalNode(this.feature, this.value, this.score, this.deviance, trueChild, falseChild);
    }

    @Override
    public String dot(StructType schema, StructField response, int id) {
        StructField field = schema.field(this.feature);
        return String.format(" %d [label=<%s = %s<br/>size = %d<br/>impurity reduction = %.4f>, fillcolor=\"#00000000\"];\n", id, field.name, field.toString((Object)this.value), this.size(), this.score);
    }

    @Override
    public String toString(StructType schema, boolean trueBranch) {
        Object values;
        StructField field = schema.field(this.feature);
        if (trueBranch) {
            values = field.toString((Object)this.value);
        } else {
            Measure measure = field.measure;
            if (measure instanceof NominalScale) {
                NominalScale scale = (NominalScale)measure;
                values = Arrays.stream(scale.values()).filter(v -> v != this.value).mapToObj(arg_0 -> ((NominalScale)scale).level(arg_0)).collect(Collectors.joining(","));
            } else {
                values = "/=" + this.value;
            }
        }
        return String.format("%s=%s", field.name, values);
    }
}

