/*
 * Decompiled with CFR 0.152.
 */
package smile.base.cart;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import smile.base.cart.DecisionNode;
import smile.base.cart.LeafNode;
import smile.base.cart.Node;
import smile.base.cart.RegressionNode;
import smile.data.Tuple;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.math.MathEx;

public abstract class InternalNode
implements Node {
    final int size;
    Node trueChild;
    Node falseChild;
    final int feature;
    final double score;
    final double deviance;

    public InternalNode(int feature, double score, double deviance, Node trueChild, Node falseChild) {
        this.size = trueChild.size() + falseChild.size();
        this.feature = feature;
        this.score = score;
        this.deviance = deviance;
        this.trueChild = trueChild;
        this.falseChild = falseChild;
    }

    @Override
    public abstract LeafNode predict(Tuple var1);

    public abstract boolean branch(Tuple var1);

    public abstract InternalNode replace(Node var1, Node var2);

    public Node trueChild() {
        return this.trueChild;
    }

    public Node falseChild() {
        return this.falseChild;
    }

    public int feature() {
        return this.feature;
    }

    public double score() {
        return this.score;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int leaves() {
        return this.trueChild.leaves() + this.falseChild.leaves();
    }

    @Override
    public double deviance() {
        return this.deviance;
    }

    @Override
    public int depth() {
        return Math.max(this.trueChild.depth(), this.falseChild.depth()) + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Node merge() {
        Object a;
        this.trueChild = this.trueChild.merge();
        this.falseChild = this.falseChild.merge();
        Node node = this.trueChild;
        if (node instanceof DecisionNode) {
            DecisionNode left = (DecisionNode)node;
            node = this.falseChild;
            if (node instanceof DecisionNode) {
                DecisionNode right = (DecisionNode)node;
                if (left.output() != right.output()) return this;
                a = left.count();
                int[] b = right.count();
                int[] count = new int[((int[])a).length];
                for (int i = 0; i < count.length; ++i) {
                    count[i] = (int)(a[i] + b[i]);
                }
                return new DecisionNode(count);
            }
        }
        if (!(this.trueChild instanceof RegressionNode) || !(this.falseChild instanceof RegressionNode) || ((RegressionNode)this.trueChild).output() != ((RegressionNode)this.falseChild).output()) return this;
        a = (RegressionNode)this.trueChild;
        RegressionNode b = (RegressionNode)this.falseChild;
        return new RegressionNode(this.size, ((RegressionNode)a).output(), ((double)((RegressionNode)a).size * ((RegressionNode)a).mean() + (double)b.size * b.mean()) / (double)this.size, ((RegressionNode)a).impurity() + b.impurity());
    }

    public abstract String toString(StructType var1, boolean var2);

    @Override
    public int[] toString(StructType schema, StructField response, InternalNode parent, int depth, BigInteger id, List<String> lines) {
        BigInteger trueId = id.shiftLeft(1);
        BigInteger falseId = trueId.add(BigInteger.ONE);
        int[] c1 = this.falseChild.toString(schema, response, this, depth + 1, falseId, lines);
        int[] c2 = this.trueChild.toString(schema, response, this, depth + 1, trueId, lines);
        int k = c1.length;
        int[] count = new int[k];
        if (k == 1) {
            count[0] = this.size;
        } else {
            count = new int[k];
            for (int i = 0; i < k; ++i) {
                count[i] = c1[i] + c2[i];
            }
        }
        StringBuilder line = new StringBuilder();
        line.append(" ".repeat(depth));
        line.append(id).append(") ");
        line.append(parent == null ? "root" : parent.toString(schema, this == parent.trueChild)).append(" ");
        line.append(this.size).append(" ");
        line.append(String.format("%.5g", this.deviance())).append(" ");
        if (k == 1) {
            double output = this.sumy() / (double)this.size;
            line.append(String.format("%g", output)).append(" ");
        } else {
            int output = MathEx.whichMax((int[])count);
            line.append(response.toString((Object)output)).append(" ");
            double[] prob = new double[count.length];
            DecisionNode.posteriori(count, prob);
            line.append(Arrays.stream(prob).mapToObj(p -> String.format("%.5g", p)).collect(Collectors.joining(" ", "(", ")")));
        }
        lines.add(line.toString());
        return count;
    }

    private double sumy() {
        double f;
        double t;
        Node node = this.trueChild;
        if (node instanceof InternalNode) {
            InternalNode split = (InternalNode)node;
            t = split.sumy();
        } else {
            node = this.trueChild;
            if (node instanceof RegressionNode) {
                RegressionNode leaf = (RegressionNode)node;
                t = leaf.output() * (double)leaf.size();
            } else {
                throw new IllegalStateException("Call sumy() on DecisionTree?");
            }
        }
        Node node2 = this.falseChild;
        if (node2 instanceof InternalNode) {
            InternalNode split = (InternalNode)node2;
            f = split.sumy();
        } else {
            node2 = this.falseChild;
            if (node2 instanceof RegressionNode) {
                RegressionNode leaf = (RegressionNode)node2;
                f = leaf.output() * (double)leaf.size();
            } else {
                throw new IllegalStateException("Call sumy() on DecisionTree?");
            }
        }
        return t + f;
    }
}

