/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.Arrays;
import java.util.Properties;
import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Formula;
import smile.data.type.StructType;
import smile.regression.Regression;

public interface DataFrameRegression
extends Regression<Tuple> {
    public Formula formula();

    public StructType schema();

    default public double[] predict(DataFrame data) {
        this.formula().bind(data.schema());
        return data.stream().mapToDouble(this::predict).toArray();
    }

    public static DataFrameRegression of(final Formula formula, DataFrame data, Properties params, Regression.Trainer<double[], ?> trainer) {
        DataFrame X = formula.x(data);
        final StructType schema = X.schema();
        double[][] x = X.toArray(false, CategoricalEncoder.DUMMY, new String[0]);
        double[] y = formula.y(data).toDoubleArray();
        Object model = trainer.fit((T[])x, y, params);
        return new DataFrameRegression(){
            final /* synthetic */ Regression val$model;
            {
                this.val$model = regression;
            }

            @Override
            public Formula formula() {
                return formula;
            }

            @Override
            public StructType schema() {
                return schema;
            }

            @Override
            public double predict(Tuple x) {
                return this.val$model.predict(formula.x(x).toArray(new String[0]));
            }
        };
    }

    public static DataFrameRegression ensemble(final DataFrameRegression ... models) {
        return new DataFrameRegression(){
            private final boolean online;
            {
                this.online = Arrays.stream(models).allMatch(Regression::online);
            }

            @Override
            public boolean online() {
                return this.online;
            }

            @Override
            public Formula formula() {
                return models[0].formula();
            }

            @Override
            public StructType schema() {
                return models[0].schema();
            }

            @Override
            public double predict(Tuple x) {
                double y = 0.0;
                for (DataFrameRegression model : models) {
                    y += model.predict(x);
                }
                return y / (double)models.length;
            }

            @Override
            public void update(Tuple x, double y) {
                for (DataFrameRegression model : models) {
                    model.update(x, y);
                }
            }
        };
    }

    public static interface Trainer<M extends DataFrameRegression> {
        default public M fit(Formula formula, DataFrame data) {
            Properties params = new Properties();
            return this.fit(formula, data, params);
        }

        public M fit(Formula var1, DataFrame var2, Properties var3);
    }
}

