/*
 * Decompiled with CFR 0.152.
 */
package smile.deep.activation;

import smile.deep.activation.ActivationFunction;

public class LeakyReLU
implements ActivationFunction {
    static LeakyReLU instance = new LeakyReLU(0.01);
    private double a;

    public LeakyReLU(double a) {
        if (a < 0.0 || a >= 1.0) {
            throw new IllegalArgumentException("Invalid Leaky ReLU parameter: " + a);
        }
        this.a = a;
    }

    @Override
    public String name() {
        return "LeakyReLU";
    }

    @Override
    public void f(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            x[i] = Math.max(this.a * x[i], x[i]);
        }
    }

    @Override
    public void g(double[] g, double[] y) {
        for (int i = 0; i < g.length; ++i) {
            int n = i;
            g[n] = g[n] * (y[i] > 0.0 ? 1.0 : this.a);
        }
    }
}

