/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.io.Serializable;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.clustering.KMeans;
import smile.clustering.PartitionClustering;
import smile.math.MathEx;
import smile.math.blas.UPLO;
import smile.math.matrix.ARPACK;
import smile.math.matrix.IMatrix;
import smile.math.matrix.Matrix;

public class SpectralClustering
extends PartitionClustering
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(SpectralClustering.class);
    public final double distortion;

    public SpectralClustering(double distortion, int k, int[] y) {
        super(k, y);
        this.distortion = distortion;
    }

    public static SpectralClustering fit(Matrix W, int k) {
        return SpectralClustering.fit(W, k, 100, 1.0E-4);
    }

    public static SpectralClustering fit(Matrix W, int k, int maxIter, double tol) {
        int i;
        if (k < 2) {
            throw new IllegalArgumentException("Invalid number of clusters: " + k);
        }
        int n = W.nrow();
        double[] D = W.colSums();
        for (i = 0; i < n; ++i) {
            if (D[i] == 0.0) {
                throw new IllegalArgumentException("Isolated vertex: " + i);
            }
            D[i] = 1.0 / Math.sqrt(D[i]);
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double w = D[i] * W.get(i, j) * D[j];
                W.set(i, j, w);
                W.set(j, i, w);
            }
        }
        W.uplo(UPLO.LOWER);
        Matrix.EVD eigen = ARPACK.syev((IMatrix)W, (ARPACK.SymmOption)ARPACK.SymmOption.LA, (int)k);
        double[][] Y = eigen.Vr.toArray();
        for (int i2 = 0; i2 < n; ++i2) {
            MathEx.unitize2((double[])Y[i2]);
        }
        KMeans kmeans = KMeans.fit(Y, k, maxIter, tol);
        return new SpectralClustering(kmeans.distortion, k, kmeans.y);
    }

    public static SpectralClustering fit(double[][] data, int k, double sigma) {
        return SpectralClustering.fit(data, k, sigma, 100, 1.0E-4);
    }

    public static SpectralClustering fit(double[][] data, int k, double sigma, int maxIter, double tol) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid number of clusters: " + k);
        }
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Invalid standard deviation of Gaussian kernel: " + sigma);
        }
        int n = data.length;
        double gamma = -0.5 / (sigma * sigma);
        Matrix W = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double w = Math.exp(gamma * MathEx.squaredDistance((double[])data[i], (double[])data[j]));
                W.set(i, j, w);
                W.set(j, i, w);
            }
        }
        return SpectralClustering.fit(W, k, maxIter, tol);
    }

    public static SpectralClustering fit(double[][] data, int k, int l, double sigma) {
        return SpectralClustering.fit(data, k, l, sigma, 100, 1.0E-4);
    }

    public static SpectralClustering fit(double[][] data, int k, int l, double sigma, int maxIter, double tol) {
        int i2;
        if (l < k || l >= data.length) {
            throw new IllegalArgumentException("Invalid number of random samples: " + l);
        }
        if (k < 2) {
            throw new IllegalArgumentException("Invalid number of clusters: " + k);
        }
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Invalid standard deviation of Gaussian kernel: " + sigma);
        }
        int n = data.length;
        double gamma = -0.5 / (sigma * sigma);
        int[] index = MathEx.permutate((int)n);
        double[][] x = new double[n][];
        for (int i3 = 0; i3 < n; ++i3) {
            x[i3] = data[index[i3]];
        }
        Matrix C = new Matrix(n, l);
        double[] D = new double[n];
        IntStream.range(0, n).parallel().forEach(i -> {
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                double w = Math.exp(gamma * MathEx.squaredDistance((double[])x[i], (double[])x[j]));
                int n2 = i;
                D[n2] = D[n2] + w;
                if (j >= l) continue;
                C.set(i, j, w);
            }
        });
        for (i2 = 0; i2 < n; ++i2) {
            if (D[i2] < 1.0E-4) {
                logger.error(String.format("Small D[%d] = %f. The data may contain outliers.", i2, D[i2]));
            }
            D[i2] = 1.0 / Math.sqrt(D[i2]);
        }
        for (i2 = 0; i2 < n; ++i2) {
            for (int j = 0; j < l; ++j) {
                C.set(i2, j, D[i2] * C.get(i2, j) * D[j]);
            }
        }
        Matrix W = C.submatrix(0, 0, l - 1, l - 1);
        W.uplo(UPLO.LOWER);
        Matrix.EVD eigen = ARPACK.syev((IMatrix)W, (ARPACK.SymmOption)ARPACK.SymmOption.LA, (int)k);
        double[] e = eigen.wr;
        double scale = Math.sqrt((double)l / (double)n);
        for (int i4 = 0; i4 < k; ++i4) {
            if (e[i4] <= 1.0E-8) {
                throw new IllegalStateException("Non-positive eigen value: " + e[i4]);
            }
            e[i4] = scale / e[i4];
        }
        Matrix U = eigen.Vr;
        for (int i5 = 0; i5 < l; ++i5) {
            for (int j = 0; j < k; ++j) {
                U.mul(i5, j, e[j]);
            }
        }
        double[][] Y = C.mm(U).toArray();
        for (int i6 = 0; i6 < n; ++i6) {
            MathEx.unitize2((double[])Y[i6]);
        }
        KMeans kmeans = KMeans.fit(Y, k, maxIter, tol);
        int[] y = new int[n];
        for (int i7 = 0; i7 < n; ++i7) {
            y[index[i7]] = kmeans.y[i7];
        }
        return new SpectralClustering(kmeans.distortion, k, y);
    }
}

