/*
 * Decompiled with CFR 0.152.
 */
package smile.base.mlp;

import java.io.Serializable;
import smile.math.MathEx;

public interface ActivationFunction
extends Serializable {
    public String name();

    public void f(double[] var1);

    public void g(double[] var1, double[] var2);

    public static ActivationFunction linear() {
        return new ActivationFunction(){

            @Override
            public String name() {
                return "LINEAR";
            }

            @Override
            public void f(double[] x) {
            }

            @Override
            public void g(double[] g, double[] y) {
            }
        };
    }

    public static ActivationFunction rectifier() {
        return new ActivationFunction(){

            @Override
            public String name() {
                return "RECTIFIER";
            }

            @Override
            public void f(double[] x) {
                for (int i = 0; i < x.length; ++i) {
                    x[i] = Math.max(0.0, x[i]);
                }
            }

            @Override
            public void g(double[] g, double[] y) {
                for (int i = 0; i < g.length; ++i) {
                    int n = i;
                    g[n] = g[n] * (y[i] > 0.0 ? 1.0 : 0.0);
                }
            }
        };
    }

    public static ActivationFunction leaky() {
        return ActivationFunction.leaky(0.01);
    }

    public static ActivationFunction leaky(final double a) {
        if (a < 0.0 || a >= 1.0) {
            throw new IllegalArgumentException("Invalid Leaky ReLU parameter: " + a);
        }
        return new ActivationFunction(){

            @Override
            public String name() {
                return String.format("LEAKEY_RECTIFIER(%f)", a);
            }

            @Override
            public void f(double[] x) {
                for (int i = 0; i < x.length; ++i) {
                    x[i] = Math.max(a * x[i], x[i]);
                }
            }

            @Override
            public void g(double[] g, double[] y) {
                for (int i = 0; i < g.length; ++i) {
                    int n = i;
                    g[n] = g[n] * (y[i] > 0.0 ? 1.0 : a);
                }
            }
        };
    }

    public static ActivationFunction sigmoid() {
        return new ActivationFunction(){

            @Override
            public String name() {
                return "SIGMOID";
            }

            @Override
            public void f(double[] x) {
                for (int i = 0; i < x.length; ++i) {
                    x[i] = MathEx.sigmoid((double)x[i]);
                }
            }

            @Override
            public void g(double[] g, double[] y) {
                for (int i = 0; i < g.length; ++i) {
                    int n = i;
                    g[n] = g[n] * (y[i] * (1.0 - y[i]));
                }
            }
        };
    }

    public static ActivationFunction tanh() {
        return new ActivationFunction(){

            @Override
            public String name() {
                return "TANH";
            }

            @Override
            public void f(double[] x) {
                for (int i = 0; i < x.length; ++i) {
                    x[i] = Math.tanh(x[i]);
                }
            }

            @Override
            public void g(double[] g, double[] y) {
                int n = y.length;
                int i = 0;
                while (i < n) {
                    double ym1 = 1.0 - y[i];
                    int n2 = i++;
                    g[n2] = g[n2] * (ym1 * ym1);
                }
            }
        };
    }
}

