/*
 * Decompiled with CFR 0.152.
 */
package smile.wavelet;

import smile.math.MathEx;
import smile.wavelet.Wavelet;

public interface WaveletShrinkage {
    public static void denoise(double[] t, Wavelet wavelet) {
        WaveletShrinkage.denoise(t, wavelet, false);
    }

    public static void denoise(double[] t, Wavelet wavelet, boolean soft) {
        wavelet.transform(t);
        int n = t.length;
        int nh = t.length >> 1;
        double[] wc = new double[nh];
        System.arraycopy(t, nh, wc, 0, nh);
        double error = MathEx.mad((double[])wc) / 0.6745;
        double lambda = error * Math.sqrt(2.0 * Math.log(n));
        if (soft) {
            for (int i = 2; i < n; ++i) {
                t[i] = Math.signum(t[i]) * Math.max(Math.abs(t[i]) - lambda, 0.0);
            }
        } else {
            for (int i = 2; i < n; ++i) {
                if (!(Math.abs(t[i]) < lambda)) continue;
                t[i] = 0.0;
            }
        }
        wavelet.inverse(t);
    }
}

