/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.classification.Classifier;
import smile.classification.DataFrameClassifier;
import smile.data.DataFrame;
import smile.regression.DataFrameRegression;
import smile.regression.Regression;

public interface Validation {
    public static <T> int[] test(Classifier<T> classifier, T[] x) {
        int n = x.length;
        int[] prediction = new int[n];
        for (int i = 0; i < n; ++i) {
            prediction[i] = classifier.predict(x[i]);
        }
        return prediction;
    }

    public static int[] test(DataFrameClassifier model, DataFrame data) {
        return model.predict(data);
    }

    public static <T> double[] test(Regression<T> regression, T[] x) {
        int n = x.length;
        double[] prediction = new double[n];
        for (int i = 0; i < n; ++i) {
            prediction[i] = regression.predict(x[i]);
        }
        return prediction;
    }

    public static double[] test(DataFrameRegression model, DataFrame data) {
        return model.predict(data);
    }
}

