/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.math.MathEx;
import smile.validation.RegressionMeasure;

public class RSS
implements RegressionMeasure {
    public static final RSS instance = new RSS();

    @Override
    public double measure(double[] truth, double[] prediction) {
        return RSS.of(truth, prediction);
    }

    public static double of(double[] truth, double[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        int n = truth.length;
        double rss = 0.0;
        for (int i = 0; i < n; ++i) {
            rss += MathEx.sqr((double)(truth[i] - prediction[i]));
        }
        return rss;
    }

    public String toString() {
        return "RSS";
    }
}

