/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.validation.ClassificationMeasure;
import smile.validation.ConfusionMatrix;

public class MCC
implements ClassificationMeasure {
    public static final MCC instance = new MCC();

    @Override
    public double measure(int[] truth, int[] prediction) {
        return MCC.of(truth, prediction);
    }

    public static double of(int[] truth, int[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        ConfusionMatrix confusion = ConfusionMatrix.of(truth, prediction);
        int[][] matrix = confusion.matrix;
        if (matrix.length != 2 || matrix[0].length != 2) {
            throw new IllegalArgumentException("MCC can only be applied to binary classification: " + confusion.toString());
        }
        int tp = matrix[0][0];
        int tn = matrix[1][1];
        int fp = matrix[0][1];
        int fn = matrix[1][0];
        int numerator = tp * tn - fp * fn;
        double denominator = Math.sqrt(tp + fp) * Math.sqrt(tp + fn) * Math.sqrt(tn + fp) * Math.sqrt(tn + fn);
        return (double)numerator / denominator;
    }

    public String toString() {
        return "MCC";
    }
}

