/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.validation.ClassificationMeasure;

public class FDR
implements ClassificationMeasure {
    public static final FDR instance = new FDR();

    @Override
    public double measure(int[] truth, int[] prediction) {
        return FDR.of(truth, prediction);
    }

    public static double of(int[] truth, int[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        int fp = 0;
        int p = 0;
        for (int i = 0; i < truth.length; ++i) {
            if (truth[i] != 0 && truth[i] != 1) {
                throw new IllegalArgumentException("FDR can only be applied to binary classification: " + truth[i]);
            }
            if (prediction[i] != 0 && prediction[i] != 1) {
                throw new IllegalArgumentException("FDR can only be applied to binary classification: " + prediction[i]);
            }
            if (prediction[i] != 1) continue;
            ++p;
            if (truth[i] == 1) continue;
            ++fp;
        }
        return (double)fp / (double)p;
    }

    public String toString() {
        return "False Discovery Rate";
    }
}

